<div class="row">
	<div class="col-xs-12">
		<div class="outline--septenary outline--thin background--white padding-gutters-1_2 basket">

			<div class="row">
				<div class="col-xs-12 col-sm-6">
					<h3>
						<?php if(! empty($site) && Configure::read('BuzzSites.show_location')): ?>
							<?php echo __d('buzz_bookings', 'You are booking: %d item at %s', [1, $site['Site']['name']]); ?>
						<?php else: ?>
							<?php echo __d('buzz_bookings', 'You are booking: %d item', [1]); ?>
						<?php endif; ?>
					</h3>
				</div>

				<div class="col-xs-12 col-sm-6">
					<div class="button background--nonary sm-plus-right toggle"><?php echo __d('buzz_late_bookings', 'Expand'); ?> <i class="fa fa-chevron-circle-down"></i></div>
				</div>
			</div>

			<div class="toggle__content">

				<?php if (!empty($data['LateBooking']['booking_date'])): ?>
					<div class="row">
						<div class="col-xs-12">
							<h3><?php echo __d('buzz_late_bookings', 'Your booking for %s', [$this->Time->i18nFormat($data['LateBooking']['booking_date'], '%e %B %Y')]) ?></h3>
							<p><?php echo __d('buzz_late_bookings', 'Check-in time: %s', [$data['LateBooking']['check_in_time']]); ?></p>
						</div>
					</div>
				<?php endif; ?>

				<div class="listing listing--booking">
					<div class="row">
						<div class="col-xs-12 col-sm-5 xs-extra-gutters-1 sm-plus-extra-gutters-2--left">
							<h3>
								<?php echo $this->I18n->translate($basket, 'LateBookingPackage.name'); ?>
							</h3>
							<?php if (! empty($site) && Configure::read('BuzzSites.show_location')): ?>
								<strong><?php echo __d('buzz_late_bookings', 'Location:'); ?></strong>
								<span><?php echo $site['Site']['name']; ?></span>
							<?php endif; ?>
						</div>
						<div class="col-xs-12 xs-extra-gutters-1 col-sm-2">
							<strong><?php echo __d('buzz_late_bookings', 'Time:'); ?></strong>
							<span class="h3"><?php echo date('H:i', strtotime($basket['LateBooking']['booking_date'])); ?></span>
						</div>
						<div class="col-xs-12 xs-extra-gutters-1 col-sm-1 xs-text-left text-right fa--senary">
							<?php if (!empty($item['participants'])): ?>
								<?php if ($item['participants'] < 5): ?>
									<?php for ($i = 0; $i < $item['participants']; $i++): ?>
										<i class="fa fa-user"></i>
									<?php endfor; ?>
								<?php else: ?>
									<i class="fa fa-users"></i>
								<?php endif; ?>
								<strong><?php echo $item['participants']; ?></strong>
							<?php elseif (!empty($item['ActivityPackage']['max_participants'])): ?>
								<?php $footnote = true; ?>
								<i class="fa fa-users"></i>
								<strong><?php echo $item['ActivityPackage']['max_participants']; ?> <sup>*</sup></strong>
							<?php endif; ?>
						</div>
						<div class="col-xs-12 xs-extra-gutters-1 col-sm-2 gutterless sm-plus-text-center">
							<strong><?php echo __d('buzz_late_bookings', 'Quantity:') . ' ' . h($data['LateBooking']['quantity']); ?></strong>
						</div>
						<div class="col-xs-12 xs-extra-gutters-1 col-sm-2">
							<strong><?php echo __d('buzz_late_bookings', 'Price:'); ?></strong>
							<span class="large"><?php echo $this->Number->currency($basket['LateBooking']['subtotal']); ?></span>
						</div>
					</div>
				</div>

				<?php if ($data['LateBooking']['is_insured']): ?>
					<div class="listing listing--booking">
						<div class="row">
							<div class="col-xs-12 col-sm-8 xs-extra-gutters-1 sm-plus-extra-gutters-2--left">
								<h3><?php echo __d('buzz_late_bookings', '\'Any Reason\' Protection'); ?></h3>
							</div>
							<div class="col-xs-12 xs-extra-gutters-1 col-sm-2 gutterless sm-plus-text-center">
								<strong><?php echo __d('buzz_late_bookings', 'Quantity:'); ?> 1</strong>
							</div>
							<div class="col-xs-12 xs-extra-gutters-1 col-sm-2">
								<strong><?php echo __d('buzz_late_bookings', 'Price:'); ?></strong>
								<span class="large"><?php echo $this->Number->currency($data['LateBooking']['insurance_cost']); ?></span>
							</div>
						</div>
					</div>
				<?php endif; ?>
			</div>

			<?php if (!empty($data['LateBooking']['booking_date'])): ?>
				<div class="row">
					<div class="col-xs-12 col-sm-10">
						<?php if (!empty($timeoutRedirect)): ?>
							<div class="content__spacer--small">&nbsp;</div>
							<p>
								<?php echo __d('buzz_late_bookings', 'Time remaining to complete this booking:'); ?>
								<span class="js-countdown color--warning" data-countdown-seconds="<?php echo $timeRemaining; ?>" data-countdown-load-url="<?php echo $this->Html->url($timeoutRedirect); ?>"></span>
							</p>
						<?php endif; ?>
					</div>
					<div class="col-xs-12 col-sm-2 basket__total">
						<strong><?php echo __d('buzz_late_bookings', 'Total:'); ?> <span class="large"><?php echo $this->Number->currency($data['LateBooking']['total_cost']); ?></strong>
					</div>
				</div>
				<?php endif; ?>

		</div>

		<div class="content__spacer"></div>
	</div>
</div>
