<?= $this->Form->create(null, ['id' => false, 'class' => 'js-late-booking-filter validate', 'url' => ['action' => 'find_deals', 'ajax' => true]]) ?>
<div class="row">
	<div class="col-sm-4">
		<div class="custom-select--large">
			<?= $this->Form->input('activities_id', ['empty' => __('All Activities')]) ?>
		</div>
	</div>
	<?php if (count($sites) > 1): ?>
		<div class="col-sm-4">
			<div class="custom-select--large">
				<?= $this->Form->input('api_site_id', [
					'label' => __d('buzz_late_bookings', 'Location'),
					'empty' => __d('buzz_late_bookings', 'Select Location'),
					'options' => $sites,
					'aria-required' => 'true',
					'required' => true,
					'class' => 'required'
				]) ?>
			</div>
		</div>
	<?php else: ?>
		<?php
		reset($sites);
		echo $this->Form->hidden('api_site_id', ['value' => key($sites)]);
		?>
	<?php endif; ?>
	<div class="col-sm-8">
		<?= $this->Form->label('participants', 'Number of Participants') ?>
		<div class="row">
			<div class="col-sm-6">
				<div class="custom-select--large">
					<?= $this->Form->input('participants', [
						'label' => false,
						'type' => 'select',
						'empty' => __('Please Select')
					]) ?>
				</div>
			</div>

			<div class="col-sm-6">
				<?= $this->Form->button(__d('buzz_late_bookings', 'Show me deals'), [
					'class' => 'button button--submit'
				]) ?>
			</div>
		</div>
	</div>
</div>
<?= $this->Form->end() ?>
<br />
<div class="js-late-booking-cal">
	<p>
		<strong><?= h('Please select number of participants above to see available late deals') ?></strong>
	</p>
</div>
