<div class="gw field">

	<div class="g one-half">
		<?php
			echo $this->Html->tag('h3', __d('buzz_bookings', 'Customer Address'));
			echo $this->Address->format(
				$this->request->data['CustomerAddress'],
				[
					'address_line_1',
					'address_line_2',
					'address_line_3',
					'city',
					'postcode',
					'Country.name'
				]
			);
		?>
	</div>

</div>
<div class="gw field">

	<div class="g">
		<table class='data-table'>
			<thead>
				<tr>
					<th><?= __d('buzz_bookings', 'Package'); ?></th>
					<th><?= __d('buzz_bookings', 'Date'); ?></th>
					<th><?= __d('buzz_bookings', 'Time'); ?></th>
					<th><?= __d('buzz_bookings', 'Participants'); ?></th>
					<th><?= __d('buzz_bookings', 'Quantity'); ?></th>
					<th><?= __d('buzz_bookings', 'Total'); ?></th>
				</tr>
			</thead>
			<tbody>
					<tr>
						<td>
							<?= $this->request->data['LateBookingPackage']['name']; ?>
						</td>
						<td>
							<?= date('d/m/y', strtotime($this->request->data['LateBooking']['booking_date'])); ?>
						</td>
						<td>
							<?= date('H:i', strtotime($this->request->data['LateBooking']['booking_date'])); ?>
						</td>
						<td>
							<?= $this->request->data['LateBookingPackage']['participants'] ?: __d('buzz_bookings', 'Group / Party Booking'); ?>
						</td>
						<td>
							1
						</td>
						<td>
							<?= $this->Number->currency($this->request->data['LateBookingPackage']['price']); ?>
						</td>
					</tr>
				<?php if ($this->request->data['LateBooking']['is_insured']): ?>
					<tr>
						<td colspan="4" style="text-align:left">
							<?= __d('buzz_bookings', '\'Any Reason\' Protection'); ?>
						</td>
						<td>
							1
						</td>
						<td>
							<?= $this->request->data['LateBooking']['insurance_cost']; ?>
						</td>
					</tr>
				<?php endif; ?>
			</tbody>
			<tfoot>
				<tr>
					<th colspan="5" class="text--right"><?= __d('buzz_late_bookings', 'Total Cost'); ?></th>
					<th><?= $this->Number->currency($this->request->data['LateBooking']['total_cost']); ?></th>
				</tr>
			</tfoot>
		</table>
	</div>

</div>
