<?php
App::uses('AppModel', 'Model');

class LateBookingPackage extends BuzzLateBookingsAppModel {

/**
 * Behaviors
 *
 * @var array
 */
	public $actsAs = array(
		'BuzzTranslate.Translatable'
	);

/**
 * Belongs to associations
 *
 * @var array
 */
	public $belongsTo = array(
		'Activity' => array(
			'className' => 'BuzzBookings.Activity'
		)
	);

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'api_reference' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			),
			'max' => array(
				'rule' => array('maxLength', 80),
				'message' => 'No more than 80 characters long',
			)
		),
		'api_additional_notes' => array(
			'max' => array(
				'rule' => array('maxLength', 250),
				'message' => 'No more than 250 characters long',
				'allowEmpty' => true
			)
		),
		'api_discount_code' => array(
			'max' => array(
				'rule' => array('maxLength', 45),
				'message' => 'No more than 45 characters long',
				'allowEmpty' => true
			)
		),
		'participants' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			),
		),
		'name' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			),
			'max' => array(
				'rule' => array('maxLength', 150),
				'message' => 'No more than 150 characters long'
			)
		),
		'activity_id' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			)
		),
		'price' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			),
			'decimal' => array(
				'rule' => '|^\d+(\.\d{2})?$|',
				'message' => 'Decimal numbers only'
			)
		)
	);

/**
 * Image slots
 *
 * @var array
 */
	public $imageSlots = [
		'main' => [
			'slots' => 1,
			'fields' => []
		]
	];

	public function getActivities() {
		return $this->Activity->translatedList([
			'joins' => [
				[
					'table' => 'late_booking_packages',
					'alias' => 'LateBookingPackage',
					'type' => 'INNER',
					'conditions' => 'LateBookingPackage.activity_id = Activity.id'
				]
			],
			'conditions' => [
				'Activity.api_reference IS NOT NULL',
				'Activity.api_reference <>' => '',
				'Activity.is_hidden_activity' => false,
				'LateBookingPackage.is_active' => true
			],
			'order' => [
				'Activity.sequence' => 'ASC',
				'Activity.created' => 'ASC'
			]
		]);
	}

}
