<?php

App::uses('BuzzSourceAppModel', 'BuzzSource.Model');

class LateBookingApi extends BuzzSourceAppModel {

	/**
	 * Get last minute dates at a specific site
	 *
	 * @param int $siteId Location/Site ID
	 * @param string $fromDate From date
	 * @param string $toDate To date
	 * @return array
	 */
	public function getLastMinuteDatesBySite($siteId, $fromDate, $toDate) {
		$result = $this->find('all', array(
			'method' => 'GetLastMinuteDates',
			'conditions' => array(
				'siteId' => $siteId,
				'fromdate' => $fromDate,
				'todate' => $toDate
			)
		));

		return !empty($result['LateBookingApi']['d']) ? $this->_processDates($result['LateBookingApi']['d']) : false;
	}

	protected function _processDates($data) {
		$result = [];

		// Set some date/time variables ready for use later so that we don't
		// need to keep calculating these.
		$today = date('d/m/Y');
		$twoHoursFromNow = date('H:i', strtotime('+2 hours'));

		foreach ($data as $date) {
			$times = [];
			foreach ($date['Itineraries'] as $itinerary) {
				if (
					count($itinerary) === 1
					&& ((string)$date['Date'] !== $today || $itinerary[0]['FromTime'] >= $twoHoursFromNow)
				) {
					$times[] = [
						'date' => self::dateToSqlFormat($date['Date']),
						'activity_api_id' => $itinerary[0]['ActivityId'],
						'package_api_id' => $itinerary[0]['BookingTypeId'],
						'description' => $itinerary[0]['Description'],
						'check_in' => $itinerary[0]['CheckInMins'],
						'from_time' => $itinerary[0]['FromTime'],
						'to_time' => $itinerary[0]['ToTime'],
						'peak' => (bool)$itinerary[0]['IsPeak'],
						'experience_id' => $itinerary[0]['ExperienceId'],
						'quantity' => $itinerary[0]['BookingTypeQuantity']
					];
				}
			}

			if (!empty($times)) {
				// Store in the results array.
				$result[] = array(
					'date' => self::dateToSqlFormat($date['Date']),
					'times' => $times
				);
			}
		}
		return $result;
	}

}
