<?php

App::uses('CakeEventListener', 'Event');

class LateBookingListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'Model.LateBooking.completed' => 'confirmation'
		);
	}

	/**
	 * Send emails on confirmation of a booking.
	 *
	 * @param CakeEvent $Event
	 * @return void
	 */
	public function confirmation(CakeEvent $Event) {
		$purchase = ClassRegistry::init('BuzzLateBookings.LateBooking')->getPurchase($Event->data['id']);

		// Send confirmation email
		$this->_sendConfirmation($purchase);

		// If the booking is for today we want to send an email informing the
		// site of the booking.
		if (date('dmY', strtotime($purchase['LateBooking']['booking_date'])) === date('dmY')) {
			$this->_sendSameDayEmail($purchase);
		}

		return;
	}

	/**
	 * Sends a same day booking email.
	 *
	 * @param array $purchase
	 * @return void
	 */
	protected function _sendSameDayEmail($purchase) {
		// Send confirmation email
		$Email = ClassRegistry::init('BuzzEmails.Email');
		$email = ClassRegistry::init('BuzzEmails.Email')->generateEmailData(
			'BuzzBookings.same_day_booking',
			[
				'salesRef' => $purchase['LateBooking']['sales_ref'],
				'fullName' => $purchase['CustomerAddress']['first_name'] . ' ' . $purchase['CustomerAddress']['last_name'],
				'firstName' => $purchase['CustomerAddress']['first_name'],
				'lastName' => $purchase['CustomerAddress']['last_name'],
				'date' => date('j F Y', strtotime($purchase['LateBooking']['booking_date'])),
				'time' => date('H:i', strtotime($purchase['LateBooking']['booking_date']))
			]
		);
		$Email->queueEmail(
			$email['Email']['subject'],
			$email['Email']['content'],
			$email['Email']['to'],
			$email['Email']['from']
		);

		return;
	}

	protected function _sendConfirmation($purchase) {
		// Send confirmation email
		$Controller = new Controller();
		$Controller->helpers = ['BuzzTranslate.I18n'];
		$View = new View($Controller);
		$View->set('data', $purchase);
		$details = $View->render('BuzzLateBookings./LateBookings/email_basket', 'ajax');

		$Email = ClassRegistry::init('BuzzEmails.Email');
		$email = ClassRegistry::init('BuzzEmails.Email')->generateEmailData(
			'BuzzBookings.confirmation_email',
			[
				'salesRef' => $purchase['LateBooking']['sales_ref'],
				'details' => $details,
				'fullName' => $purchase['CustomerAddress']['first_name'] . ' ' . $purchase['CustomerAddress']['last_name'],
				'firstName' => $purchase['CustomerAddress']['first_name'],
				'lastName' => $purchase['CustomerAddress']['last_name'],
				'checkin' => $purchase['LateBooking']['check_in_time'],
				'date' => date('j F Y', strtotime($purchase['LateBooking']['booking_date'])),
				'time' => date('H:i', strtotime($purchase['LateBooking']['booking_date']))
			]
		);
		$Email->queueEmail(
			$email['Email']['subject'],
			$email['Email']['content'],
			array($purchase['CustomerAddress']['email'] => $purchase['CustomerAddress']['first_name'] . ' ' . $purchase['CustomerAddress']['last_name']),
			$email['Email']['from']
		);

		return;
	}

}
