<?php
App::uses('BuzzLateBookingsAppController', 'BuzzLateBookings.Controller');

class LateBookingPackagesController extends BuzzLateBookingsAppController {

/**
 * Admin form fields
 *
 * @return array
 */
	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		$fields['LateBookingPackage.participants']['type'] = 'select';

		$fields['LateBookingPackage.package_api_reference']['after'] = '<p class="input__help">' . __d('buzz_late_bookings', 'Used for checking availability in the diary.') . '</p>';

		$fields['LateBookingPackage.api_additional_notes']['after'] = '<p class="input__help">' . __d('buzz_late_bookings', 'Passed to the API when completing a booking.') . '</p>';

		return $fields;
	}

/**
 * Populate admin lookups
 *
 * @return void
 */
	protected function _adminPopulateLookups() {
		$activities = $this->LateBookingPackage->Activity->find('list', [
			'conditions' => [
				'Activity.api_reference <>' => null
			]
		]);
		$participants = array_combine(range(1, 12), range(1, 12));
		$this->set(compact('activities', 'participants'));
		return;
	}

/**
 * Admin index paginate
 *
 * @return array
 */
	protected function _adminIndexPaginate() {
		$conditions = $this->_processFilter();

		$paginate = array(
			'conditions' => $conditions,
			'contain' => array(
				'Activity'
			)
		);

		return $paginate;
	}

/**
 * Admin index columns
 *
 * @return array
 */
	protected function _adminIndexColumns() {
		$columns = parent::_adminIndexColumns();

		$newColumns = array(
			'Activity.name' => array(
				'label' => __d('buzz_late_bookings', 'Activity'),
				'type' => 'string'
			)
		);

		return ArrayUtil::addAfter($columns, 'LateBookingPackage.name', $newColumns);
	}

/**
 * Filters
 *
 * @return array
 */
	protected function _adminFilterFields() {
		$filters = parent::_adminFilterFields();

		$newFilters = array(
			'LateBookingPackage.activity_id' => array(
				'label' => __d('buzz_bookings', 'Activity'),
				'type' => 'select',
				'compare' => array('LateBookingPackage.activity_id' => "%s")
			)
		);

		return ArrayUtil::addAfter($filters, 'Booking.sales_ref', $newFilters);
	}

}
