<?php
class BuzzLateBookings extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'BuzzLateBookings';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_table' => array(
				'late_booking_packages' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'),
					'name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 150, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
					'activity_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'description' => array('type' => 'text', 'null' => true, 'default' => null, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
					'price' => array('type' => 'decimal', 'null' => false, 'default' => '0.00', 'length' => '5,2', 'unsigned' => false),
					'participants' => array('type' => 'integer', 'null' => false, 'default' => '0', 'unsigned' => false),
					'package_api_reference' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 80, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
					'api_additional_notes' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
					'api_discount_code' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
					'is_active' => array('type' => 'boolean', 'null' => false, 'default' => '1'),
					'is_removed' => array('type' => 'boolean', 'null' => false, 'default' => '0'),
					'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'utf8mb4', 'collate' => 'utf8mb4_bin', 'engine' => 'InnoDB'),
				),
				'late_bookings' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'),
					'sales_ref' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
					'late_booking_package_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false),
					'customer_address_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'check_in_time' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 5, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
					'booking_date' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'quantity' => array('type' => 'integer', 'null' => true, 'default' => '1', 'unsigned' => false),
					'subtotal' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '10,2', 'unsigned' => false),
					'is_insured' => array('type' => 'boolean', 'null' => false, 'default' => '0'),
					'insurance_cost' => array('type' => 'decimal', 'null' => true, 'default' => '0.00', 'length' => '10,2', 'unsigned' => false),
					'total_cost' => array('type' => 'decimal', 'null' => true, 'default' => '0.00', 'length' => '10,2', 'unsigned' => false),
					'booking_state_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'api_log' => array('type' => 'text', 'null' => true, 'default' => null, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
					'is_removed' => array('type' => 'boolean', 'null' => false, 'default' => '0'),
					'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'completed_date' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'utf8mb4', 'collate' => 'utf8mb4_bin', 'engine' => 'InnoDB'),
				),
			),
		),
		'down' => array(
			'drop_table' => array(
				'late_booking_packages', 'late_bookings'
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
