<?php
	echo $this->Html->css(array(
		'sortable'
	));
?>
<div class='edit-form'>

	<div class='edit-form__header'>
		<h1 class='title'><?php echo $this->InflectorExt->camelToPluralize($displayName) ?> <span>Administration</span></h1>
		<h2 class='title edit-form__title'>
			<?php echo __d('admin', 'Reorder Images'); ?>
		</h2>
		<?php echo $this->Element('toolbar') ?>
	</div>

	<div id="pane">
		<div id="controls">
			<?php echo $this->Html->link(__d('admin', 'Save'), '#', ['class' => 'button save-reorderlisting']); ?>
		</div>
		<ol class="cakesortable">
			<?php
				foreach ($data as $key => $value):
					echo '<li id="list_' . $key . '"><div><span>' . $this->Image->resize($value, ['width' => 120, 'height' => 90]) . '</span></div>';
				endforeach;
			?>
		</ol>

	</div>

</div>
<script>
	<?php
		echo 'document.orderkey = "' . $order_key . '";';
		echo 'document.maxdepth = "' . $max_depth . '";';
	?>
</script>

<?php
	echo $this->Form->create(null, array(
		'inputDefaults'=>array(
				'empty'=>''
		),
		'type' => 'file',
		'class' => '',
		'id' => 'cakeform'
	));
?>

<div id="reorderFormContents"></div>

<?php echo $this->Form->end(); ?>

<?php
	echo $this->Html->script(
		array(
			'jquery.mjs.nestedSortable',
			'sortable'
		),
		array('inline' => false)
	);
