<?php

App::uses('BuzzGalleryAppModel', 'BuzzGallery.Model');

class GalleryImage extends BuzzGalleryAppModel {

	public $displayField = 'caption';

/**
 * Behaviors
 *
 * @var array
 */
	public $actsAs = array(
		'BuzzTranslate.Translatable'
	);

/**
 * HABTM associations
 *
 * @var array
 */
	public $hasAndBelongsToMany = array(
		'Gallery' => array(
			'className' => 'BuzzGallery.Gallery'
		)
	);

/**
 * Read for edit
 *
 * @param int $id
 * @param array $query
 * @return array
 */
	public function readForEdit($id, $query = []) {
		$query['contain'][] = 'Gallery';
		return parent::readForEdit($id, $query);
	}

	public function __construct($id = false, $table = null, $ds = null) {
		$this->imageSlots = array(
			'main' => array(
				'fields' => array(
					'alt' => array(
						'label' => __('Alt Text'),
					)
				),
				'slots' => 1
			)
		);
		parent::__construct($id, $table, $ds);
	}

}
