<?php

App::uses('BuzzGalleryAppModel', 'BuzzGallery.Model');

class Gallery extends BuzzGalleryAppModel {

	/**
	 * Behaviors
	 *
	 * @var array
	 */
	public $actsAs = array(
		'BuzzTranslate.Translatable'
	);

	/**
	 * HABTM associations
	 *
	 * @var array
	 */
	public $hasAndBelongsToMany = array(
		'GalleryImage' => array(
			'className' => 'BuzzGallery.GalleryImage'
		)
	);

	/**
	 * Has many associations
	 *
	 * @var array
	 */
	public $hasMany = array(
		'GalleryRelation' => array(
			'className' => 'BuzzGallery.GalleryRelation'
		)
	);

	/**
	 * Read for view. If there are no images in the gallery it will return an
	 * empty array.
	 *
	 * @param int $id
	 * @param array $params
	 * @return array
	 */
	public function readForView($id, $params = []) {
		$params['contain'] = array(
			'GalleryImage' => array(
				'Image'
			)
		);
		$params['conditions']['Gallery.is_active'] = true;
		$data = parent::readForView($id, $params);

		// Sort by sequence.
		$data['GalleryImage'] = Hash::sort($data['GalleryImage'], '{n}.GalleriesGalleryImage.sequence', 'asc');

		return !empty($data['GalleryImage']) ? $data : [];
	}

}
