<?php

App::uses('BuzzGalleryAppController', 'BuzzGallery.Controller');

class GalleryImagesController extends BuzzGalleryAppController {

	public $components = array(
		'BuzzTranslate.Translation' => array(
			'fields' => array(
				'caption'
			)
		)
	);

/**
 * Admin index paginate
 *
 * @return array
 */
	protected function _adminIndexPaginate() {
		$GalleryImage = $this->{$this->modelClass};

		$paginate = parent::_adminIndexPaginate();
		$paginate['fields'] = array(
			'GalleryImage.*',
			'Gallery.name'
		);
		$paginate['contain'][] = 'Image';
		$paginate['joins'][] = array(
			'table' => 'galleries_gallery_images',
			'alias' => 'GalleriesGalleryImages',
			'type' => 'LEFT',
			'conditions' => array(
				'GalleriesGalleryImages.gallery_image_id = GalleryImage.id'
			)
		);
		$paginate['joins'][] = array(
			'table' => 'galleries',
			'alias' => 'Gallery',
			'type' => 'INNER',
			'conditions' => array(
				'Gallery.id = GalleriesGalleryImages.gallery_id'
			)
		);
		$paginate['group'] = 'GalleryImage.id';

		return $paginate;
	}

	protected function _adminFilterFields() {
		$filters = parent::_adminFilterFields();

		$newFilters = array(
			'GalleriesGalleryImages.gallery_id' => array(
				'label' => __d('BuzzGallery', 'Gallery'),
				'type' => 'select',
				'compare' => array('GalleriesGalleryImages.gallery_id' => '%s')
			)
		);

		return ArrayUtil::addAfter($filters, 'GalleryImage.caption', $newFilters);
	}

	protected function _adminIndexColumns() {
		$GalleryImage = $this->{$this->modelClass};

		$columns = parent::_adminIndexColumns();
		$newColumns['Image.filename'] = ['type' => 'image', 'label' => __('Image')];

		return ArrayUtil::addAfter($columns, $GalleryImage->alias . '.id', $newColumns);
	}

/**
 * Admin add/edit
 *
 * @param int $id
 * @return void
 */
	public function admin_edit($id = null) {
		parent::admin_edit($id);
		$this->Translation->adminTranslationFormFields();
		return;
	}

/**
 * Admin form fields
 *
 * @return array
 */
	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		$newFields['Gallery.Gallery'] = array(
			'label' => __('Galleries'),
			'type' => 'multicheck'
		);

		$fields = ArrayUtil::addAfter($fields, 'GalleryImage.caption', $newFields);

		return $fields;
	}

/**
 * Populate admin lookups
 *
 * @return void
 */
	protected function _adminPopulateLookups() {
		$GalleryImage = $this->{$this->modelClass};

		$this->set('galleries', $GalleryImage->Gallery->find('list'));

		return;
	}

}
