<?php

App::uses('BuzzGalleryAppController', 'BuzzGallery.Controller');

class GalleriesController extends BuzzGalleryAppController {

	public $components = array(
		'BuzzTranslate.Translation' => array(
			'fields' => array(
				'name'
			)
		)
	);

	public function beforeFilter() {
		$this->adminActions[] = 'admin_reorder_images';
		parent::beforeFilter();
		return;
	}

/**
 * Admin add/edit
 *
 * @param int $id
 * @return void
 */
	public function admin_edit($id = null) {
		parent::admin_edit($id);
		$this->Translation->adminTranslationFormFields();
		return;
	}

	public function admin_reorder_images($id) {
		$Gallery = $this->{$this->modelClass};

		if (!empty($this->request->data['reorder'])) {
			unset($this->request->data['log']);

			$result = $Gallery->GalleryRelation->saveMany(
				$this->request->data['reorder'],
				array(
					'callbacks' => false,
					'fieldList' => array(
						'id',
						'sequence'
					)
				)
			);

			if ($result !== false) {
				$this->Session->setFlash(
					array(
						'title' => __('Order Saved'),
						'description' => __('Reordering has been saved successfully!')
					),
					'flash_success'
				);
			} else {
				$this->Session->setFlash(
					array(
						'title' => __('Reordering Failed'),
						'description' => __('There was an error saving the data')
					),
					'flash_fail'
				);
			}

			return $this->redirect(['action' => 'edit', $id]);

		}

		$data = $Gallery->GalleryRelation->find('all', array(
			'contain' => array(
				'GalleryImage' => array(
					'Image'
				)
			),
			'conditions' => array(
				'GalleryRelation.gallery_id' => $id
			),
			'order' => 'GalleryRelation.sequence'
		));
		$data = Hash::combine($data, '{n}.GalleryRelation.id', '{n}.GalleryImage.Image.0');

		// Let javascript know whats going on too.
		$this->set('order_key', 'sequence');
		$this->set('max_depth', 1);
		$this->set('data', $data);

		$this->view = 'BuzzGallery.admin_reorder_images';

		return;
	}

	protected function _adminFormToolbar($id = null) {
		$Gallery = $this->{$this->modelClass};

		$actions = parent::_adminFormToolbar($id);

		if ($id !== null) {
			$actions[__d('admin', 'Reorder')] = [
				'url' => ['action' => 'reorder_images', $id],
				'icon' => 'bars'
			];
		}

		return $actions;
	}

}
