<?php
$this->extend('/Common/2col');
$this->assign('title', $this->I18n->translate($data, 'Facility.name'));
$this->start('side');
?>
	<?php
		if (count($facilities) > 1):
			echo $this->Fa->link('chevron-circle-left fa-inline', __d('buzz_facilities', 'Back to Facilities'), ['action' => 'index'], ['class' => 'button button--fill', 'before' => true, 'space' => false]);
		endif;
	?>

	<div class="content__spacer"></div>

	<?php
		$adverts = count($data['Advert']);
		$i = 0;
		foreach ($data['Advert'] as $advert):
			echo $this->Advert->render($advert);
			++$i;
			echo $i < $adverts ? '<div class="content__spacer advert-spacer"></div>' : null;
		endforeach;
	?>
<?php $this->end(); // side ?>

<?php if (!empty($data['Image'][0])): ?>
	<div class="text-center">
		<?php echo $this->Img->resize($data['Image'][0], ['width' => 870]); ?>
	</div>
	<div class="content__spacer"></div>
<?php endif; ?>

<div class="content__intro">
	<?php echo $this->I18n->translate($data, 'Facility.content'); ?>
</div>
<?php if (!empty($data['Facility']['secondary_content'])): ?>
	<div class="toggle__content">
		<?php echo $this->I18n->translate($data, 'Facility.secondary_content'); ?>
	</div>
	<p class="toggle"><?php echo __d('buzz_facilities', 'Read More'); ?> <i class="fa fa-chevron-circle-down"></i></p>
<?php endif; ?>

<?php if (!empty($gallery) || !empty($data['Facility']['video_url'])): ?>
	<div class="row">
		<?php
			if (!empty($gallery)):
				$class = !empty($data['Facility']['video_url']) ? 'col-md-6' : 'col-md-12';
		?>
			<div class="col-xs-12 <?php echo $class; ?>">
				<?php echo $this->element('BuzzGallery.mini_gallery', ['data' => $gallery['GalleryImage']]); ?>

				<div class="content__spacer"></div>
			</div>
		<?php endif; ?>
		<?php
			if (!empty($data['Facility']['video_url'])):
				$class = !empty($gallery) ? 'col-md-6' : 'col-md-12';
		?>
			<div class="col-xs-12 <?php echo $class; ?>">
				<div class="aspect aspect--16_9">
					<!-- force iframe to full width 16:9 ratio with css -->
					<?php echo !empty($data['Facility']['video_url']) ? $this->Video->embed($data['Facility']['video_url'], ['width' => '100%', 'height' => '100%']) : null; ?>
				</div>
			</div>
		<?php endif; ?>
	</div>
<?php endif; ?>

<div class="row">
	<div class="col-xs-12">
		<div class="content__spacer"></div>

		<?php $tabs = count($data['Tab']) + (int)!empty($data['FacilityPackage']); ?>

		<?php if ($tabs >= 1): ?>

			<div class="responsivetabs">
				<ul>
					<?php if (!empty($data['FacilityPackage'])): ?>
						<li><?php echo $this->Html->link(__d('buzz_facilities', 'Packages'), '#tab-0'); ?></li>
					<?php endif; ?>
					<?php $i = 0; ?>
					<?php foreach ($data['Tab'] as $tab): ?>
						<?php ++$i; ?>
						<li><?php echo $this->Html->link($this->I18n->translate($tab, 'title'), '#tab-' . $i); ?></li>
					<?php endforeach; ?>
				</ul>
				<?php if (!empty($data['FacilityPackage'])): ?>
					<div id="tab-0"><?php echo $this->element('BuzzFacilities.facility_packages'); ?></div>
				<?php endif; ?>
				<?php $i = 0; ?>
				<?php foreach ($data['Tab'] as $tab): ?>
					<?php ++$i; ?>
					<div id="tab-<?php echo $i; ?>">
						<?php echo !empty($tab['Image'][0]) ? $this->Img->resize($tab['Image'][0], ['width' => 870], ['class' => 'center full']) . '<br />' : null; ?>
						<?php echo $this->I18n->translate($tab, 'content'); ?>
					</div>
				<?php endforeach; ?>
			</div>

		<?php else: ?>

			<?php if (!empty($data['FacilityPackage'])): ?>
				<h2><?php echo __d('buzz_facilities', 'Packages'); ?></h2>
				<?php echo $this->element('BuzzFacilities.facility_packages'); ?>
			<?php else: ?>
				<h2><?php echo $this->I18n->translate($data, 'Tab.0.title'); ?></h2>
				<?php echo !empty($data['Tab'][0]['Image'][0]) ? $this->Img->resize($data['Tab'][0]['Image'][0], ['width' => 870], ['class' => 'center full']) . '<br />' : null; ?>
				<?php echo $this->I18n->translate($data, 'Tab.0.content'); ?>
			<?php endif; ?>

		<?php endif; ?>

	</div>
</div>
