<?php
$this->extend('/Common/view');
$title = !empty($data) ? $this->I18n->translate($data, 'Page.title') : __d('buzz_facilities', 'Facilities');
$this->assign('title', $title);
$this->start('intro');
	if (!empty($data)):
		echo $this->I18n->translate($data, 'Page.body');
	endif;
$this->end(); // intro
?>

<?php
	$itemsPerRow = count($facilities);
	$itemsPerRow = $itemsPerRow > 4 ? 4 : $itemsPerRow;
?>

<?php $tabs = count($data['Tab']) + (int)!empty($data['FacilityPackage']); ?>

<?php if ($tabs >= 1): ?>

	<div class="responsivetabs">
		<ul>
			<?php if (!empty($data['FacilityPackage'])): ?>
				<li><?php echo $this->Html->link(__d('buzz_facilities', 'Packages'), '#tab-0'); ?></li>
			<?php endif; ?>
			<?php $i = 0; ?>
			<?php foreach ($data['Tab'] as $tab): ?>
				<?php ++$i; ?>
				<li><?php echo $this->Html->link($this->I18n->translate($tab, 'title'), '#tab-' . $i); ?></li>
			<?php endforeach; ?>
		</ul>
		<?php if (!empty($data['FacilityPackage'])): ?>
			<div id="tab-0"><?php echo $this->element('BuzzFacilities.facility_packages'); ?></div>
		<?php endif; ?>
		<?php $i = 0; ?>
		<?php foreach ($data['Tab'] as $tab): ?>
			<?php ++$i; ?>
			<div id="tab-<?php echo $i; ?>">
				<?php echo !empty($tab['Image'][0]) ? $this->Img->resize($tab['Image'][0], ['width' => 870], ['class' => 'center full']) . '<br />' : null; ?>
				<?php echo $this->I18n->translate($tab, 'content'); ?>
			</div>
		<?php endforeach; ?>
	</div>
<?php endif; ?>

<div class="row n-items" data-n-items="<?php echo $itemsPerRow; ?>">
	<?php foreach ($facilities as $facility): ?>
		<?php echo $this->element('facility', ['data' => $facility]); ?>
	<?php endforeach; ?>
</div>

<?php if (!empty($gallery)): ?>
	<div class="row">
		<div class="col-xs-12">
			<h2><?php echo $this->I18n->translate($gallery, 'Gallery.name'); ?></h2>
			<?php echo $this->element('BuzzGallery.large_gallery', ['data' => $gallery['GalleryImage']]); ?>
			<div class="content__spacer"></div>
		</div>
	</div>
<?php endif; ?>
