<?php foreach ($data['FacilityPackage'] as $package): ?>
	<div class="listing listing--activity">
		<div class="row">
			<div class="col-xs-12 col-md-2_9">
				<?php
					$img = (empty($package['Image'][0])) ? 'no-image.png' : $package['Image'][0];
					echo $this->Img->resize($img, ['width' => 670, 'height' => 510, 'crop' => true], ['class' => 'listing__image']);
				?>
				<div class="content__spacer xs-visible"></div>
			</div>

			<div class="col-xs-12 col-sm-9 col-md-5_9">
				<div class="row">
					<div class="col-xs-12 col-sm-12">
						<h3><?php echo $this->I18n->translate($package, 'name'); ?></h3>
					</div>
				</div>

				<?php echo $this->I18n->translate($package, 'description'); ?>
			</div>

			<div class="col-xs-12 col-sm-3 col-md-2_9 text-center">
				<?php if ($package['price'] === null): ?>
					<span class="listing__price">
						<h3><?php echo $this->Number->price($package['off_peak_price']); ?><br /></h3>
						<?php echo __d('buzz_facilities', '(Off Peak)'); ?>
					</span>
					<span class="listing__price">
						<h3><?php echo $this->Number->price($package['peak_price']); ?><br /></h3>
						<?php echo __d('buzz_facilities', '(Peak)'); ?>
					</span>
				<?php else: ?>
					<span class="listing__price">
						<h3><?php echo $this->Number->price($package['price']); ?><br /></h3>
					</span>
				<?php endif; ?>
				<?php if (!empty($package['telephone'])): ?>
					<br />
					<?php echo __d('buzz_facilities', 'Call to book:'); ?><br />
					<strong class="h2 color--nonary">
						<?php
							if ($this->request->is('mobile') === true):
								echo $this->Html->link(
									$package['telephone'],
									'tel:' . str_replace(' ', '', $package['telephone'])
								);
							else:
								echo $package['telephone'];
							endif;
						?>
					</strong>
				<?php endif; ?>
			</div>
		</div>

		<div class="row">
			<div class="xs-hidden col-md-2_9">&nbsp;</div>
			<div class="col-xs-12 col-md-7_9"><hr /></div>
		</div>
	</div>
<?php endforeach; ?>
