<?php

App::uses('BuzzFacilitiesAppModel', 'BuzzFacilities.Model');

class FacilityPackage extends BuzzFacilitiesAppModel {

/**
 * @var array Belongs to associations
 */
	public $belongsTo = array(
		'Facility' => array(
			'className' => 'BuzzFacilities.Facility'
		)
	);

/**
 * @var array Validation rules
 */
	public $validate = array(
		'name' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			),
			'max' => array(
				'rule' => array('maxLength', 150),
				'message' => 'No more than 150 characters long'
			)
		),
		'facility_id' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			)
		),
		'sequence' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			),
			'max' => array(
				'rule' => array('naturalNumber', true),
				'message' => 'Integer numbers only'
			)
		),
		'peak_price' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			),
			'decimal' => array(
				'rule' => '|^\d+(\.\d{2})?$|',
				'message' => 'Decimal numbers only'
			),
			'max' => array(
				'rule' => array('comparison', '<', 1000000),
				'message' => 'Value must be less than 1000000.00'
			)
		),
		'off_peak_price' => array(
			'decimal' => array(
				'rule' => '|^\d+(\.\d{2})?$|',
				'message' => 'Decimal numbers only',
				'allowEmpty' => true
			),
			'max' => array(
				'rule' => array('comparison', '<', 1000000),
				'message' => 'Value must be less than 1000000.00'
			)
		),
		'telephone' => array(
			'max' => array(
				'rule' => array('maxLength', 20),
				'message' => 'No more than 20 characters long',
				'allowEmpty' => true
			)
		),
	);

/**
 * After find logic
 *
 * @param array $results
 * @param bool $primary
 * @return array
 */
	public function afterFind($results, $primary = false) {
		foreach ($results as &$result) {
			// For packages with a single price create a price attribute. This
			// is to simplify things elsewhere.
			if (!empty($result[$this->alias]['peak_price'])) {
				$result[$this->alias]['price'] = null;
				if (
					$result[$this->alias]['peak_price'] === $result[$this->alias]['off_peak_price']
					|| empty($result[$this->alias]['off_peak_price'])
				) {
					$result[$this->alias]['price'] = $result[$this->alias]['peak_price'];
				}
			}
		}
		return $results;
	}

}
