<?php
class BuzzFacilitiesUpdatedEncoding extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'BuzzFacilities_updated_encoding';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'facilities' => array(
					'content' => array('type' => 'text', 'null' => true, 'default' => null, 'collate' => 'utf8_unicode_ci', 'charset' => 'utf8', 'after' => 'name'),
					'secondary_content' => array('type' => 'text', 'null' => true, 'default' => null, 'collate' => 'utf8_unicode_ci', 'charset' => 'utf8', 'after' => 'content'),
					'gallery_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false, 'after' => 'theme_id'),
				),
			),
			'alter_field' => array(
				'facilities' => array(
					'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_unicode_ci'),
				),
				'facility_packages' => array(
					'name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 150, 'collate' => 'utf8_unicode_ci', 'charset' => 'utf8'),
					'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_unicode_ci'),
				),
			),
		),
		'down' => array(
			'drop_field' => array(
				'facilities' => array('content', 'secondary_content', 'gallery_id'),
			),
			'alter_field' => array(
				'facilities' => array(
					'tableParameters' => array('charset' => 'latin1', 'collate' => 'latin1_swedish_ci', 'engine' => 'InnoDB'),
				),
				'facility_packages' => array(
					'name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 150, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1'),
					'tableParameters' => array('charset' => 'latin1', 'collate' => 'latin1_swedish_ci', 'engine' => 'InnoDB'),
				),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
