<?php
$this->extend('/Common/view');
$title = __d('buzz_extend_voucher', 'Voucher Extension Step %d', [1]);
if (! empty($data)):
	$title = $this->I18n->translate($data, 'Page.title');
endif;
$this->assign('title', $title);
?>
<?php if (! empty($data)): ?>
	<div class="row">
		<div class="col-xs-12">
			<?= $this->I18n->translate($data, 'Page.body') ?>
		</div>
	</div>
	<div class="content__spacer">&nbsp;</div>
<?php endif; ?>
<div class="outline--septenary outline--thin background--white padding-gutters-1_2">
	<div class="row">
		<div class="col-xs-12 col-sm-7 col-sm-push-1">
			<?php echo $this->Form->create(null, ['class' => 'form--side-labels validate']); ?>

			<h3><?php echo __d('buzz_extend_voucher', 'Please enter your voucher details'); ?></h3>

			<?php
				echo $this->Form->inputs(array(
					'fieldset' => false,
					'VoucherExtension.voucher_code' => [
						'label' => __d('buzz_extend_voucher', 'Voucher Number'),
					],
					'VoucherExtension.expiry_date' => [
						'label' => __d('buzz_extend_voucher', 'Expiry Date'),
						'div' => 'input select input--datepicker',
						'placeholder' => 'YYYY-MM-DD',
					]
				));
				echo $this->Form->button(__d('buzz_extend_voucher', 'Proceed') . '<i class="fa fa-chevron-circle-right fa-inline"></i>', ['class' => 'button']);
			?>

			<?php echo $this->Form->end(); ?>

		</div>
	</div>
</div>
