<?php
App::uses('BuzzSourceAppModel', 'BuzzSource.Model');

class VoucherExtensionApi extends BuzzSourceAppModel {

/**
 * Extend a voucher
 * @param string $voucherCode        Voucher code
 * @param string $originalExpiryDate Original expiry date
 * @param string $newExpiryDate      New extended expiry date
 * @param float  $totalPaid          Total paid for extension
 * @param string $firstName          First name
 * @param string $lastName           Last name
 * @param string $email              Email address
 * @param string $telephone          Telephone number
 * @param array  $address            Address
 * @param array  $paymentDetails     Payment details
 * @return [type]                     [description]
 */
	public function extendVoucher($model, $foreignId, $voucherCode, $originalExpiryDate, $newExpiryDate, $totalPaid, $firstName, $lastName, $email, $telephone, $address, $paymentDetails) {
		$result = $this->find('all', [
			'method' => 'ExtendVoucher',
			'conditions' => [
				'vouchercode' => $voucherCode,
				'expirydate' => $originalExpiryDate,
				'newexpirydate' => $newExpiryDate,
				'amount' => $totalPaid,
				'firstname' => $firstName,
				'lastname' => $lastName,
				'email' => $email,
				'telephone' => $telephone,
				'addressline1' => $address['address_line_1'],
				'town' => $address['city'],
				'postcode' => $address['postcode'],
				'cardnumber' => '',
				'vendortxcode' => $paymentDetails['vendorTxCode'],
				'vpstxId' => $paymentDetails['vpstxId'],
				'status' => $paymentDetails['status'],
				'txauthno' => $paymentDetails['txauthno'],
				'payeereference' => '',
			],
			'apiLog' => [
				'model' => $model,
				'foreign_id' => $foreignId
			]
		]);

		return strtolower($result['VoucherExtensionApi']['d']['Status']) === 'ok' ? $result['VoucherExtensionApi']['d']['SalesOrderId'] : false;
	}

/**
 * Check a 'Bodyflight' voucher code exists and return cost
 *
 * @param string $code Voucher code
 * @param string $expiryDate Voucher expiry date
 * @return float|bool Cost or false if not found
 */
	public function checkVoucherCost($code, $expiryDate) {
		$result = $this->find('all', [
			'method' => 'CheckBodyFlightVoucherCode',
			'conditions' => [
				'voucherCode' => $code,
				'expiryDate' => $expiryDate
			]
		]);

		if (
			$result['VoucherExtensionApi']['d']['Status'] != 'Ok' &&
			strpos($result['VoucherExtensionApi']['d']['FailureDescription'], 'Voucher has expired') === false
		) {
			return false;
		}

		return ! empty($result['VoucherExtensionApi']['d']['Cost']) ? $result['VoucherExtensionApi']['d']['Cost'] : false;
	}

}
