<?php
App::uses('CakeEventListener', 'Event');
App::uses('CustomEmail', 'Lib');
App::uses('PurchaseTrait', 'BuzzPurchase.Lib/Traits');

class VoucherExtensionListener implements CakeEventListener {

	use PurchaseTrait;

	public function implementedEvents() {
		return array(
			'Model.VoucherExtension.completed' => 'sendVoucherExtensionConfirmationEmail'
		);
	}

/**
 * Send camp booking confirmation email.
 *
 * @param CakeEvent $Event
 * @return void
 */
	public function sendVoucherExtensionConfirmationEmail(CakeEvent $Event) {
		$id = $Event->data['id'];

		$data = ClassRegistry::init('BuzzExtendVoucher.VoucherExtension')->getPurchase($id);

		// Calculate the tax.
		$taxPercent = Configure::read('BuzzPurchase.taxPercent');
		$tax = empty($taxPercent) ? 0 : $this->calculateTax($data['VoucherExtension']['total_cost'], $taxPercent);

		// Send payment request email
		$Email = ClassRegistry::init('BuzzEmails.Email');
		$tokens = [
			'fullName' => $data['CustomerAddress']['first_name'] . ' ' . $data['CustomerAddress']['last_name'],
			'firstName' => $data['CustomerAddress']['first_name'],
			'lastName' => $data['CustomerAddress']['last_name'],
			'amount' => CakeNumber::currency($data['VoucherExtension']['total_cost']),
			'salesRef' => $data['VoucherExtension']['sales_ref'],
			'voucherCode' => $data['VoucherExtension']['voucher_code'],
			'newExpiryDate' => CakeTime::i18nFormat($data['VoucherExtension']['new_expiry_date'], '%e %B %Y'),
			'tax' => CakeNumber::currency($tax)
		];
		$email = ClassRegistry::init('BuzzEmails.Email')->generateEmailData(
			'BuzzExtendVoucher.confirmation_email',
			$tokens
		);
		$Email->queueEmail(
			$email['Email']['subject'],
			$email['Email']['content'],
			[$data['CustomerAddress']['email'] => $tokens['fullName']],
			$email['Email']['from']
		);

		return;
	}

}
