<?php
class BuzzExtendVoucherAddNoneSetting extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'BuzzExtendVoucher_add_none_setting';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
		),
		'down' => array(
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		$Settings = ClassRegistry::init('SiteSettings.SiteSetting');
		$chargeType = $Settings->findByName('voucher_extend_charge_type');
		if (empty($chargeType)) {
			return true;
		} elseif ($direction === 'up') {
			$chargeType['SiteSetting']['options'] = implode("\n", [
				'Use API Cost',
				'Percentage',
				'Fixed Amount',
			]);
		} else {
			$chargeType['SiteSetting']['options'] = implode("\n", [
				'Percentage',
				'Fixed Amount'
			]);
		}

		return $Settings->save($chargeType);
	}
}
