<?php
class BuzzExtendVoucherAddEmailTemplates extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'BuzzExtendVoucher_add_email_templates';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
		),
		'down' => array(
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		$EmailGroup = ClassRegistry::init('BuzzEmails.EmailGroup');
		$Email = ClassRegistry::init('BuzzEmails.Email');
		if ($direction === 'up') {
			$EmailGroup->save([
				'name' => 'Voucher Extensions',
			]);
			$Email->save([
				'name' => 'Voucher Extensions Confirmation',
				'system_name' => 'BuzzExtendVoucher.confirmation_email',
				'email_group_id' => $EmailGroup->id,
				'subject' => 'Voucher Extensions Confirmation',
				'content' => '<p>Hi {firstName},</p><p>Your sales reference is: <strong>{salesRef}</strong></p><p>Your voucher {voucherCode} has been extended until {newExpiryDate}. A payment of {amount} has been received.</p><p>Includes VAT of {tax}.</p>',
				'required_tokens' => '["voucherCode","newExpiryDate"]',
				'optional_tokens' => '["fullName","firstName","lastName","salesRef","amount","tax"]'
			]);
		} else {
			$groupId = $EmailGroup->findByName('Voucher Extensions');
			if (! empty($groupId)) {
				$Email->deleteAll(['Email.email_group_id' => $groupId]);
				$EmailGroup->delete($groupId);
			}
		}

		return true;
	}
}
