<?php
class BuzzExtendVoucherStates extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'BuzzExtendVoucher_states';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_table' => array(
				'buzz_extend_voucher_voucher_extension_states' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => true, 'key' => 'primary'),
					'name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'utf8mb4', 'collate' => 'utf8mb4_general_ci', 'engine' => 'InnoDB'),
				),
			),
			'create_field' => array(
				'buzz_extend_voucher_voucher_extensions' => array(
					'voucher_code' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4', 'after' => 'sales_ref'),
					'original_expiry_date' => array('type' => 'date', 'null' => true, 'default' => null, 'after' => 'voucher_code'),
					'new_expiry_date' => array('type' => 'date', 'null' => true, 'default' => null, 'after' => 'original_expiry_date'),
					'voucher_extension_state_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false, 'after' => 'total_cost'),
				),
			),
		),
		'down' => array(
			'drop_table' => array(
				'buzz_extend_voucher_voucher_extension_states'
			),
			'drop_field' => array(
				'buzz_extend_voucher_voucher_extensions' => array('voucher_code', 'original_expiry_date', 'new_expiry_date', 'voucher_extension_state_id'),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction === 'up') {
			$data = array(
				array(
					'id' => 1,
					'name' => 'Unpaid'
				),
				array(
					'id' => 2,
					'name' => 'Complete'
				),
				array(
					'id' => 3,
					'name' => 'Payment Failed'
				),
				array(
					'id' => 4,
					'name' => 'API Failed'
				),
			);
			ClassRegistry::init('BuzzExtendVoucher.VoucherExtensionState')->saveMany($data);
		} else {
			ClassRegistry::init('BuzzExtendVoucher.VoucherExtensionState')->deleteAll(['1 = 1']);
		}

		return true;
	}
}
