<?php
class AddSiteSettingsForBuzzExtendVoucher extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'Add_site_settings_for_BuzzExtendVoucher';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
		),
		'down' => array(
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		$Settings = ClassRegistry::init('SiteSettings.SiteSetting');
		$SiteSettingCategory = ClassRegistry::init('SiteSettings.SiteSettingCategory');
		if ($direction === 'up') {
			$SiteSettingCategory->save(['name' => 'Voucher Extensions']);
			$categoryId = $SiteSettingCategory->id;
			$Settings->saveMany([
				[
					'label' => 'Grace Period (days)',
					'name' => 'voucher_extend_grace_period',
					'type' => 'number',
					'value' => 14,
					'sequence' => 1,
					'site_setting_category_id' => $categoryId,
				],
				[
					'label' => 'Redemption Period (months)',
					'name' => 'voucher_extend_redemption_period',
					'type' => 'number',
					'value' => 12,
					'sequence' => 2,
					'site_setting_category_id' => $categoryId,
				],
				[
					'label' => 'Charge Type',
					'name' => 'voucher_extend_charge_type',
					'type' => 'select',
					'value' => 'Percentage',
					'options' => implode("\n", [
						'Percentage',
						'Fixed Amount',
						'Cost',
					]),
					'sequence' => 3,
					'site_setting_category_id' => $categoryId,
				],
				[
					'label' => 'Charge Amount',
					'name' => 'voucher_extend_charge_amount',
					'type' => 'number',
					'value' => 20,
					'sequence' => 4,
					'site_setting_category_id' => $categoryId,
				],
			]);
		} else {
			$categoryId = $SiteSettingCategory->findByName('Voucher Extensions');
			$Settings->deleteAll(['site_setting_category_id' => $categoryId]);
			$SiteSettingCategory->delete($categoryId);
		}

		return true;
	}
}
