<?php
$this->extend('/Common/view');
$this->assign('title', __d('buzz_extend_voucher', 'Voucher Extension Step %d', [3]));
?>
<?= $this->Form->create(null, ['class' => 'validate']); ?>

<?= $this->element('BuzzExtendVoucher.basket', ['basket' => $basket, 'paid' => false]) ?>

<div class="content__spacer"></div>

<div class="row">
	<div class="col-xs-12">
		<h2><?= __d('buzz_extend_voucher', 'Please enter your billing and payment details') ?></h2>
	</div>
</div>

<div class="row">
	<div class="col-xs-12 col-md-6">
		<h3><?= __d('buzz_extend_voucher', 'Billing details') ?></h3>
		<div class="form--side-labels form--compact validate">
			<?= $this->element('BuzzCustomers.address_form') ?>
			<?= $this->Form->input('CustomerAddress.telephone', ['label' => __d('buzz_extend_voucher', 'Telephone')]) ?>
			<?= $this->Form->input('CustomerAddress.email', ['label' => __d('buzz_extend_voucher', 'Email')]) ?>
		</div>
	</div>
	<div class="col-xs-12 col-md-6">
		<?php foreach ($conditions as $condition): ?>
			<div class="input checkbox checkbox--custom checkbox--left clear">
				<?= $this->Form->checkbox('condition.' . $condition['Condition']['id'], ['class' => 'required']); ?>
				<?= $this->Form->label('condition.' . $condition['Condition']['id'], $this->I18n->translate($condition, 'Condition.rendered_content')); ?>
			</div>
		<?php endforeach; ?>
	</div>
</div>

<div class="booking__actions">
	<div class="row">
		<div class="col-xs-6">
			<?= $this->Html->link(__d('buzz_extend_voucher', 'Back'), ['action' => 'basket'], ['class' => 'button button--light background--septenary left']); ?>
		</div>

		<div class="col-xs-6">
			<?= $this->Form->button(__d('buzz_extend_voucher', 'Pay Now') . '<i class="fa fa-credit-card fa-inline"></i>', ['class' => 'button button--dark background--senary right button--booking-proceed']) ?>
		</div>
	</div>
</div>

<?= $this->Form->end(); ?>
