<?php

class EmailFixture extends CakeTestFixture {

	public $import = 'BuzzEmails.Email';

	public $records = array(
		array(
			'id' => 1,
			'name' => 'Test',
			'subject' => 'Foo bar',
			'content' => '<p>Hi {full_name},</p><p>Regards<br />{site_name}</p>',
			'required_tokens' => '["full_name","site_name"]',
			'optional_tokens' => null
		),
		array(
			'id' => 2,
			'name' => 'Test (no tokens)',
			'subject' => 'Hello',
			'content' => '<p>Hello world</p>',
			'required_tokens' => null,
			'optional_tokens' => null
		),
		array(
			'id' => 3,
			'name' => 'Test (advanced tokens)',
			'subject' => 'Hello (again)',
			'content' => '<p>Hello {name}</p><p>{==block==}</p>',
			'required_tokens' => '["==block=="]',
			'optional_tokens' => '["name"]'
		),
		array(
			'id' => 4,
			'name' => 'Test (subject with token)',
			'subject' => 'Booking {ref}',
			'content' => '<p>Hello</p>',
			'required_tokens' => '["ref"]',
			'optional_tokens' => null
		)
	);

}
