<?php

class EmailTest extends CakeTestCase {

	public $fixtures = array(
		'plugin.buzz_emails.Email',
		'plugin.buzz_translate.Translation',
	);

	public function setUp() {
		parent::setUp();
		$this->Email = ClassRegistry::init('BuzzCustomers.Email');
	}

	public function testGenerateEmailDataWithTokens() {
		$result = $this->Email->generateEmailData(1, ['full_name' => 'Joe Bloggs', 'site_name' => 'Example']);
		$this->assertEquals('Foo bar', $result['Email']['subject']);
		$this->assertEquals('<p>Hi Joe Bloggs,</p><p>Regards<br />Example</p>', $result['Email']['content']);

		$result = $this->Email->generateEmailData(1, ['full_name' => null, 'site_name' => 'Example']);
		$this->assertEquals('Foo bar', $result['Email']['subject']);
		$this->assertEquals('<p>Hi ,</p><p>Regards<br />Example</p>', $result['Email']['content']);

		$result = $this->Email->generateEmailData(4, ['ref' => 'foo']);
		$this->assertEquals('Booking foo', $result['Email']['subject']);

		return;
	}

	public function testGenerateEmailDataNoTokens() {
		$result = $this->Email->generateEmailData(2, []);
		$this->assertEquals('Hello', $result['Email']['subject']);
		$this->assertEquals('<p>Hello world</p>', $result['Email']['content']);

		return;
	}

	public function testGenerateEmailDataWithAdvancedTokens() {
		$result = $this->Email->generateEmailData(3, ['name' => 'Joe Bloggs', 'block' => '<div>Goodbye</div>']);
		$this->assertEquals('Hello (again)', $result['Email']['subject']);
		$this->assertEquals('<p>Hello Joe Bloggs</p><div>Goodbye</div>', $result['Email']['content']);

		return;
	}

	public function testValidation() {
		$result = $this->Email->save(['id' => 1, 'content' => '<p>Hi {full_name},</p><p>Best regards<br />{site_name}</p>']);
		$this->assertTrue($result !== false);

		return;
	}

	public function testValidationFails() {
		$result = $this->Email->save(['id' => 1, 'content' => '<p>Hi,</p><p>Regards<br />{site_name}</p>']);
		$this->assertFalse($result);

		return;
	}

}
