<?php

App::uses('BuzzEmailsAppController', 'BuzzEmails.Controller');

class EmailsController extends BuzzEmailsAppController {

/**
 * Supported admin actions
 *
 * @var array
 */
	public $adminActions = array(
		'admin_index',
		'admin_edit',
		'admin_template_preview'
	);

	public $components = array(
		'BuzzTranslate.Translation' => array(
			'fields' => array(
				'subject',
				'content'
			)
		)
	);

	public function admin_edit($id = null) {
		parent::admin_edit($id);

		if ($id !== null) {
			// We need to make sure that the email tokens (that we're not
			// saving) don't get lost between page loads. So we fetch them
			// again.
			$data = $this->Email->findById($id);
			$this->request->data['Email']['required_tokens'] = $data['Email']['required_tokens'];
			$this->request->data['Email']['optional_tokens'] = $data['Email']['optional_tokens'];

			if ($data['Email']['override_to'] !== true) {
				unset($this->viewVars['fields']['Email.to_name']);
				unset($this->viewVars['fields']['Email.to_email']);
			}
		} else {
			unset($this->viewVars['fields']['Email.to_name']);
			unset($this->viewVars['fields']['Email.to_email']);
		}

		$this->Translation->adminTranslationFormFields();
		return;
	}

/**
 * Admin index paginate
 *
 * @return array
 */
	protected function _adminIndexPaginate() {
		$conditions = $this->_processFilter();

		$paginate = array(
			'conditions' => $conditions,
			'contain' => array(
				'EmailGroup'
			)
		);

		return $paginate;
	}

	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		// Hide system name, this should never be changed and is set when the
		// table is seeded.
		unset($fields['Email.system_name']);
		// Hide the override_to column (this wants setting when seeding the
		// table).
		unset($fields['Email.override_to']);

		$fields['Email.name']['displayonly'] = 'displayonly';
		$fields['Email.required_tokens']['displayonly'] = 'displayonly';
		$fields['Email.optional_tokens']['displayonly'] = 'displayonly';

		return $fields;
	}

/**
 * Admin index columns
 *
 * @return array
 */
	protected function _adminIndexColumns() {
		$Email = $this->{$this->modelClass};

		$columns = parent::_adminIndexColumns();

		// Remove modified columns.
		unset($columns['Email.created']);

		$newColumns = array(
			'EmailGroup.name' => array(
				'label' => __d('buzz_emails', 'Group'),
				'type' => 'string'
			)
		);

		return ArrayUtil::addAfter($columns, 'Email.subject', $newColumns);
	}

/**
 * Defines a whitelist of columns to be displayed on the admin index.
 *
 * @return array whitelisted columns
 */
	protected function _adminIndexColumnsWhitelist() {
		$Email = $this->{$this->modelClass};
		$alias = $Email->alias;

		$columns = parent::_adminIndexColumnsWhitelist();
		$columns[] = $alias . '.subject';

		return $columns;
	}

	protected function _adminIndexToolbar() {
		return [];
	}

	protected function _adminFormToolbar($id = null) {
		return [];
	}

/**
 * Used to populate form drop down selects
 *
 * @return void
 */
	protected function _adminPopulateLookups() {
		$this->set('emailGroups', $this->Email->EmailGroup->find('list'));
		return;
	}

/**
 * Filters
 *
 * @return array
 */
	protected function _adminFilterFields() {
		$filters = parent::_adminFilterFields();

		unset($filters['Email.created']);
		unset($filters['Email.modified']);

		$newFilters = array(
			'Email.subject' => array(
				'label' => __d('buzz_emails', 'Subject'),
				'type' => 'string',
				'compare' => array('Email.subject LIKE' => "%%%s%%")
			),
			'Email.email_group_id' => array(
				'label' => __d('buzz_emails', 'Group'),
				'type' => 'select',
				'compare' => array('Email.email_group_id' => "%s")
			)
		);

		return ArrayUtil::addAfter($filters, 'Email.name', $newFilters);
	}

/**
 * Preview the email template (admin-only)
 * @return void
 */
	public function admin_template_preview() {
		$content = '<p>This is the default email layout template.</p>';
		$content .= '<p>Lorem ipsum dolor sit amet, <a href="/">consectetur adipiscing elit</a>. Sed aliquet viverra porttitor. Nullam id blandit neque, quis elementum lorem. Vivamus volutpat dolor ac tellus laoreet varius. Pellentesque varius pharetra nisl nec placerat. Vivamus ligula leo, consectetur at feugiat id, dapibus nec nulla. Pellentesque sit amet nibh eget ligula efficitur sagittis vel et nibh. Curabitur quis pretium diam, eu sagittis eros. Curabitur fringilla auctor placerat. Aliquam ante purus, ullamcorper id tempor at, eleifend eu tellus. Praesent sed nisi dui. Nullam suscipit leo felis, ac faucibus est semper vel. Cras suscipit ante euismod, porttitor nulla at, cursus urna. Donec dictum leo eget metus eleifend, quis consectetur libero ullamcorper. Quisque aliquet porta urna, a sodales enim congue vel.</p>';
		$this->set(compact('content'));
		$this->set('settings', Configure::read('SiteSettings'));
		$this->set('strings', Configure::read('String'));
		$this->layout = 'Emails' . DS . 'html' . DS . 'default';
		$this->view = 'Emails' . DS . 'html' . DS . 'default';

		return;
	}

}
