<?php

App::uses('QueueTask', 'Queue.Console/Command/Task');
App::uses('CustomEmail', 'Lib');
App::uses('Email', 'BuzzEmail.Email');

class QueueBuzzEmailTask extends QueueTask {

	/**
	 * Run task - send email
	 *
	 * @param array $data
	 * @param int $id
	 * @return bool
	 */
	public function run($data, $id = null) {
		$Email = new CustomEmail();

		$Email->emailFormat('both');

		// Setup the email template.
		$template = !empty($data['template']) ? $data['template'] : 'default';

		// Make sure the base URL gets set.
		Router::fullBaseUrl('http://' . $data['domain']);
		$Email->domain($data['domain']);

		// Site settings.
		$settings = ClassRegistry::init('SiteSettings.SiteSetting')->find('all');
		$settings = Hash::combine($settings, '{n}.SiteSetting.name', '{n}.SiteSetting.value');
		$strings = ClassRegistry::init('SiteSettings.CmsString')->find('all');
		foreach ($strings as $string) {
			$strings[$string['CmsString']['name']] = [
				'value' => $string['CmsString']['value'],
				'__i18n' => !empty($string['CmsString']['__i18n']) ? $string['CmsString']['__i18n'] : []
			];
		}

		$Email->template($template);
		$Email->to($data['to']);
		if (!empty($data['cc'])) {
			$Email->cc($data['cc']);
		}
		if (!empty($data['bcc'])) {
			$Email->bcc($data['bcc']);
		}
		if (!empty($data['replyTo'])) {
			$Email->replyTo($data['replyTo']);
		}
		$Email->from($data['from']);
		$Email->subject($data['subject']);
		$Email->viewVars([
			'content' => $data['content'],
			'text' => ClassRegistry::init('BuzzEmails.Email')->textContent($data['content']),
			'settings' => $settings,
			'strings' => $strings
		]);
		$Email->helpers(['BuzzTranslate.I18n', 'InlineCss.InlineCss', 'Html' => ['className' => 'HtmlExt']]);
		return $Email->send();
	}

}
