<?php
namespace Evoluted\BuzzDiscount\DiscountRestrictions;
use Evoluted\PriceModifier\Interfaces\DiscountRestrictionsInterface;
use Evoluted\PriceModifier\Interfaces\BasketInterface;
/**
 * The basic discount restriction handler allows all discount types through without
 * restricting them.
 *
 * @package 	PriceModifier
 * @author 		Rick Mills <rick@evoluted.net>
 * @author		Evoluted New Media <developers@evoluted.net>
 * @license     http://mit-license.org/
 *
 * @link		https://github.com/evolutednewmedia/pricemodifier
 *
 */
class ActivityPackage implements DiscountRestrictionsInterface
{
	public $restrictions;
	/**
     * @var Evoluted\PriceModifier\Interfaces\BasketInterface
     */
	public $basket;

	public $disountCode;
	/**
	 * Construct the discount restriction handler
	 *
	 * @param BasketInterface $basket Basket to use
	 */
	public function __construct(BasketInterface $basket)
	{
		$this->setBasket($basket);
	}
	/**
	 * Set the basket to use
	 *
	 * @param BasketInterface $basket Basket Handler
	 *
	 * @return Basic Returns the entire class with the handler applied
	 */
	public function setBasket($basket)
	{
		$this->basket = $basket;
		return $this;
	}
	/**
	 * Returns the basket
	 *
	 * @return BasketInterface Basket Handler
	 */
	public function basket()
	{
		return $this->basket;
	}

	public function setDiscountCode($discountCode)
	{
		$this->discountCode = $discountCode;
	}

	/**
	 * Sets the restrictions on the basket.
	 *
	 * @return void
	 */
	public function setRestrictions()
	{
		$ActivityPackage = \ClassRegistry::init('BuzzBooking.ActivityPackage');

		$packages = $ActivityPackage->find('all', array(
			'conditions' => array(
				'OR' => array(
					array('use_all_discount_codes' => 1),
					array('valid_discount_codes IS NOT NULL')
				)
			)
		));

		$appliedDiscount = $this->basket()->discountData;
		$validPackages = array();

		foreach ($packages as $package) {
			$valid = false;

			if ($package['ActivityPackage']['use_all_discount_codes'] == '1') {
				$valid = true;
			} elseif (! empty($package['ActivityPackage']['valid_discount_codes'])) {

				$discountCodes = explode(",", $package['ActivityPackage']['valid_discount_codes']);
				if (in_array($appliedDiscount['Code'], $discountCodes)) {
					// The discount code was found on the product
					$valid = true;
				}
			}

			if ($valid) {
				$validPackages[] = 'ActivityPackage.' . $package['ActivityPackage']['id'] . '.OFFPEAK';

				if ($package['ActivityPackage']['off_peak_discounts_only'] != '1') {
					$validPackages[] = 'ActivityPackage.' . $package['ActivityPackage']['id'] . '.PEAK';
				}
			}
		}

		$this->basket->validDiscounts = array();
		foreach ($this->basket->discountRules as $rules) {

			foreach ($validPackages as $validPackage) {
				$this->basket->validDiscounts[$rules['id']][] = $validPackage;
			}
		}
	}
}
