<?php
$libPath = App::pluginPath('BuzzDiscount') . 'Lib' . DS;

// Yes, this is actually the correct way to do this in cake. App::import is discouraged from use if its not a vendor package, which its not.
require_once($libPath . 'DiscountRestrictions' . DS . 'ActivityPackage.php');
require_once($libPath . 'DiscountRestrictions' . DS . 'GiftVoucher.php');
require_once($libPath . 'DiscountModifiers' . DS . 'FixedAmountModifier.php');
require_once($libPath . 'DiscountModifiers' . DS . 'PercentageModifier.php');
require_once($libPath . 'DiscountModifiers' . DS . 'CashDiscountModifier.php');

class Discount {

	var $discount;

	var $priceModifier;

	var $basket;

	public function __construct($discount, $basket) {
		$this->discount = $discount;
		$this->basket = $basket;

		$this->priceModifier = new Evoluted\PriceModifier\PriceModifier(
			new Evoluted\PriceModifier\Basket\Basket(new Evoluted\PriceModifier\Storage\Session, '1')
		);
	}

	public function applyDiscount($type = 'booking') {
		$validFrom = DateTime::createFromFormat('d/m/Y', $this->discount['ValidFromDate']);
		$validFrom = $validFrom->getTimestamp();

		$expiryDate = DateTime::createFromFormat('d/m/Y', $this->discount['ExpiryDate']);
		$expiryDate = $expiryDate->getTimestamp();


		if ($validFrom > time() || $expiryDate < time()) {
			return false;
		}

		if ($type == 'voucher') {
			$restrictionHandler = 'Evoluted\BuzzDiscount\DiscountRestrictions\GiftVoucher';

			$this->__populateVoucherBasket();
		} else {
			$restrictionHandler = 'Evoluted\BuzzDiscount\DiscountRestrictions\ActivityPackage';

			$this->__populateBasket();
		}

		// Set up the discount rule handler
		$this->priceModifier->setDiscountRestrictionHandler($restrictionHandler);

		// Add discount rules
		$this->__addDiscountRules();

		// Add out discount data to the basket (custom implementation)
		$this->priceModifier->basket()->discountData = $this->discount;

		// Apply discounts
		$this->priceModifier->applyDiscounts();

		return $this->priceModifier->basket()->toArray();
	}

	private function __addDiscountRules() {
		$discount = $this->discount;


		if (! empty($discount['CashDiscount'])) {

			$this->priceModifier->addDiscountModifier('cashDiscount', 'Evoluted\BuzzDiscount\DiscountModifiers\CashDiscountModifier');

			// Deduct a fixed amount from basket
			$this->priceModifier->addDiscountRule([
				'id' => 'cashDiscount',
				'discountType' => 'cashDiscount',
				'amount' => $discount['CashDiscount'],
				'applyToItems' => true,
				'quantity' => $discount['Quantity']
			]);

		} elseif (! empty($discount['FixedAmount'])) {
			// Add the discount modifier
			$this->priceModifier->addDiscountModifier('fixedAmount', 'Evoluted\BuzzDiscount\DiscountModifiers\FixedAmountModifier');

			// Modify the item totals of a row to a fixed amount
			$this->priceModifier->addDiscountRule([
				'id' => 'fixedAmount',
				'discountType' => 'fixedAmount',
				'amount' => $discount['FixedAmount'],
				'applyToItems' => true,
				'quantity' => $discount['Quantity']
			]);
		} elseif (! empty($discount['PercentageDiscount'])) {

			$this->priceModifier->addDiscountModifier('buzzPercentage', 'Evoluted\BuzzDiscount\DiscountModifiers\PercentageModifier');

			// Deduct a percentage from items
			$this->priceModifier->addDiscountRule([
				'id' => 'percentage',
				'discountType' => 'buzzPercentage',
				'percent' => $discount['PercentageDiscount'],
				'applyToItems' => true,
				'quantity' => $discount['Quantity']
			]);
		}
	}

	private function __populateBasket() {
		$basketData = array(
			'id' => $this->basket['Booking']['id'],
			'items' => array()
		);

		foreach ($this->basket['BookingItem'] as $item) {
			$ref = 'BookingItem.' . $item['id'];

			if (! empty($item['ActivityPackage']['id'])) {
				$ref = 'ActivityPackage.' . $item['ActivityPackage']['id'];

				if ($item['ActivityPackage']['peak_price'] == $item['item_unit_cost']) {
					$ref .= '.PEAK';
				} else {
					$ref .= '.OFFPEAK';
				}

			}

			if ($item['is_upsell']) {
				$ref .='.UPSELL';
			}

			if (! empty($item['BookingItemVoucher'])) {
				$ref .='.HASVOUCHER';
			}

			$itemExtra = array(
				'reference' => $ref,
				'amount' => $item['item_unit_cost']
			);

			$basketData['items'][] = array_merge($item, $itemExtra);
		}

		$this->priceModifier->basket()->populate($basketData);
	}

	private function __populateVoucherBasket() {
		$basketData = array(
			'id' => $this->basket['GiftVoucherPurchase']['id'],
			'items' => array()
		);

		foreach ($this->basket['GiftVoucherPurchaseItem'] as $item) {
			$ref = 'BookingItem.' . $item['id'];

			if (! empty($item['GiftVoucher']['id'])) {
				$ref = 'GiftVoucher.' . $item['GiftVoucher']['id'];
			}

			// if ($item['is_upsell']) {
			// 	$ref .='.UPSELL';
			// }

			$itemExtra = array(
				'reference' => $ref,
				'amount' => $item['item_unit_cost']
			);

			$basketData['items'][] = array_merge($item, $itemExtra);
		}

		$this->priceModifier->basket()->populate($basketData);
	}
}
