jQuery(function ($) {
	initAccountsOverview();
	initAccountsLoadNext();
	initAccountInfo();
	initDiary();
	initAccountNotifications();
	toggleAccountRates();

	// Clear the modal of remote content on hide to prevent caching.
	$('body').on('hidden.bs.modal', '#genericModal', function () {
		$(this).removeData('bs.modal');
	});
});

function initAccountsOverview() {

	var $overview = $('.overview__details');

	if ($overview.hasClass('ajax-loader')) {
		$overview.toggleClass('ajax-loader ajax-loading');
	}

	$overview.each(function () {
		var $_this = $(this);
		$.ajax({
			'cache': false,
			'url': $_this.data('src')
		}).done(function (data) {
			$_this.removeClass('ajax-loading');
			$_this.append(data);
		});
	});

}

function initAccountsLoadNext() {

	$(document).on('click', '.js-load-next', function (e) {

		e.preventDefault();

		var $_this = $(this);

		$.ajax({
			'cache': false,
			'url': $_this.attr('href')
		}).done(function (data) {
			$_this.parents('tr').fadeOut('slow').replaceWith(
				function () { return $(data).find('tbody > *').hide(); }
			);
			$('tbody :hidden').fadeIn('slow');
		});

	});

}

function initAccountInfo() {
	var $info = $('.account-info');
	if (!$info.length) {
		return;
	}

	// Show ajax loading gif if element has class .ajax-loader
	if ($('.account-info').hasClass('ajax-loader')) {
		$('.account-info').toggleClass('ajax-loader ajax-loading');
	}

	$.ajax({
		'cache': false,
		'url': $info.data('src')
	}).done(function (data) {
		$info.append(data);
		// Only remove ajax loader if there is no more to load
		if ($info.data('rates') === 0) {
			$('.account-info').removeClass('ajax-loading');
		}
	});

	if ($info.data('rates') !== 0) {
		$.ajax({
			'cache': false,
			'url': $info.data('rates')
		}).done(function (data) {
			$('.account-info').removeClass('ajax-loading');
			$('.account-info__toggle-rates').after(data);
		});
	}
}


function initDiary() {
	var $datepicker = $('.js-diary-datepicker');
	var $siteId = $('.site-diary').data('site-id');

	if (!$datepicker.length) {
		return;

	}

	accountDatePicker();

	// Load today's diary. Delay this by 1/2 sec to account for the slow server.
	window.setTimeout(function () {
		if ($datepicker.data('date')) {
			selectDate($datepicker.data('date'));
		}
	}, 500);
	$('body').on('click', '.js-select-time', selectTime);
	$('body').on('click', '.js-cancel-booking', cancelBooking);



	function accountDatePicker() {
		var $datepicker = $('.js-diary-datepicker');

		var options = {
			'firstDay': 1,
			'numberOfMonths': 1,
			'onSelect': selectDate,
			'defaultDate': $datepicker.data('date'),
			'dateFormat': 'yy-mm-dd',
			'minDate': new Date($datepicker.attr('data-min-date')),
			'maxDate': new Date($datepicker.attr('data-max-date'))
		};

		// Check if we've got an array of unavailable dates set (in our markup as powered by the API)
		if (typeof unavailableDates != 'undefined' && unavailableDates.length) {
			options['beforeShowDay'] = unavailable;
		}

		function unavailable(date) {
			var m = (date.getMonth() + 1);
			if (m < 10) { m = '0' + m; }

			var d = date.getDate();
			if (d < 10) { d = '0' + d; }

			ymd = date.getFullYear() + '-' + m + '-' + d;

			var className = (typeof bookedDates != 'undefined' && $.inArray(ymd, bookedDates) !== -1) ? 'booked' : '';

			return ($.inArray(ymd, unavailableDates) == -1) ? [true, className] : [false, className, 'Unavailable'];

		}

		options.maxDate = (typeof expiryDate != 'undefined' && expiryDate.length) ? expiryDate : '+6m';

		$datepicker.datepicker(options);

		return;
	}


	function selectDate(date) {
		var $diaryDayView = $('.js-diary-day-view');

		// Show ajax loading gif if element has class .ajax-loader
		if ($diaryDayView.hasClass('ajax-loader')) {
			$diaryDayView.toggleClass('ajax-loader ajax-loading');
		}

		$.ajax({
			'cache': false,
			'url': '/buzz_diary_accounts/accounts/get_diary_day/' + $siteId + '/' + date.replace(/\//g, '-')
		}).done(function (data) {
			$diaryDayView.removeClass('ajax-loading');
			$diaryDayView.empty().append(data);
			// Scroll to 9am (equivalent of 540px as 1 minute ~1px)
			$('tbody', $diaryDayView).scrollTop(540);

			// Push the updated address into the address bar so that we can handle the JS toggles in
			// the sidebar.
			window.history.pushState({ 'html': data }, '', '/accounts/diary/' + $siteId + '/' + date.replace(/\//g, '-'));

			// Initialise any new custom form elements
			customFormElements();
		});

		return;
	}

	function selectTime(e) {
		// Modal loads in automatically via data-toggle attribute
		$('#genericModal')
			.on('loaded.bs.modal', function () { // loaded, NOT shown!
				// Apply UI stuff required in the dialog after it has fully ajaxed
				accountBook();

				// Initialise any new custom form elements
				customFormElements();

				// Remove ajax loader
				$(this).find('.modal-content').removeClass('ajax-loading');
			})
			// Remove modal contents when hiding, for subsequent use
			.on('hidden.bs.modal', function (e) {
				$(e.target).removeData("bs.modal").find(".modal-content").empty().html('');
			})
			// Add ajax loader
			.find('.modal-content').addClass('ajax-loading');
	}

	function cancelBooking(e) {
		// Modal loads in automatically via data-toggle attribute
		$('#genericModal')
			.on('loaded.bs.modal', function () { // loaded, NOT shown!
				// Initialise any new custom form elements if needed
				customFormElements();

				// Remove ajax loader
				$(this).find('.modal-content').removeClass('ajax-loading');
			})
			// Remove modal contents when hiding, for subsequent use
			.on('hidden.bs.modal', function (e) {
				$(e.target).removeData("bs.modal").find(".modal-content").empty().html('');
			})
			// Add ajax loader
			.find('.modal-content').addClass('ajax-loading');
	}

}

function accountBook() {
	var $form = $('#AccountBookForm');

	if (!$form.length) {
		return;
	}

	var $duration = $('#AccountDuration');
	var totalDuration = 0;
	var $totalCost = $('.js-diary-booking-total-cost');
	var $rotationText = $('.js-rotations-text');

	var rate = $totalCost.data('rate');

	if ($rotationText.length) {
		totalDuration = $rotationText.data('total');
	}

	updateRotations.apply($duration);
	$('body').on('change', $duration, updateRotations);

	$('body').on('change', $duration, function () {

		var duration = $(':selected', $duration).val();

		var value = duration * rate;
		value = value.toFixed(2);
		// Regex to replace just the value of the total (not the currency). We need to allow for
		// commas in the values as site's like Bodyflight Sweden have prices in the thousands.
		// Example total cost: '3,000Kr'
		value = $('span', $totalCost).html().replace(/([\d,]+.\d+)/, value);
		$('span', $totalCost).html(value);

	});

	function updateRotations() {
		var duration = $(':selected', this).val();

		var rotationClass = 'rotations';
		var noRotationClass = 'no-rotations';

		var $rotationHiddenField = $('#AccountRotation');

		if (totalDuration > 0) {
			if (duration == totalDuration) {
				$rotationText.text('Rotations NOT Available');
				$rotationText.removeClass(rotationClass).addClass(noRotationClass);
				$rotationHiddenField.val('0');
			} else {
				$rotationText.text($rotationText.data('src'));
				$rotationText.addClass(rotationClass).removeClass(noRotationClass);
				$rotationHiddenField.val('1');
			}
		}

	}

	return;

}

function initAccountNotifications() {

	$('body').on('change', '#AccountNotifications', function (e) {

		e.preventDefault();

		var $form = $(this).parents('form');

		$.ajax({
			cache: false,
			url: $form.attr('action'),
			data: $form.serialize()
		});

	});

}

function toggleAccountRates() {
	var $form = $('#AccountToggleFinancialForm');
	$form.on('change', 'input', function (e) {
		e.preventDefault();
		$form.submit();
	})
}
