<div class="overflow-auto">
	<table class="table--flat">
		<thead>
			<tr>
				<th><?php echo __d('buzz_diary_accounts', 'Request Date') ?></th>
				<th><?php echo __d('buzz_diary_accounts', 'Name') ?></th>
				<th><?php echo __d('buzz_diary_accounts', 'Amount Due') ?></th>
				<th><?php echo __d('buzz_diary_accounts', 'Reference') ?></th>
				<th></th>
				<th></th>
			</tr>
		</thead>
		<tbody>
			<?php if (!empty($data)): ?>
				<?php foreach ($data as $row): ?>
					<tr>
						<td><?php echo $this->Time->i18nFormat(strtotime($row['AccountPaymentRequest']['created']), '%d/%m/%Y'); ?></td>
						<td>
							<?php
								echo $this->Html->link(
									$row['AccountPaymentRequest']['name'] ?: $row['AccountPaymentRequest']['email_address'],
									'mailto:' . $row['AccountPaymentRequest']['email_address']
								);

							?>
						</td>
						<td><?php echo $this->Number->currency($row['AccountPaymentRequest']['amount']); ?></td>
						<td><?php echo $row['AccountPaymentRequest']['reference']; ?></td>
						<td>
							<?php echo $this->Html->link(__d('buzz_diary_accounts', 'Details'), '#', [
								'class' => 'payment_details',
								'data-toggle' => 'modal',
								'data-target' => '#detailsModal' . $row['AccountPaymentRequest']['id']
							]) ?>
						</td>
						<td><?php echo $this->Html->link(__d('buzz_diary_accounts', 'Cancel'), ['controller' => 'account_payment_requests', 'action' => 'cancel', $row['AccountPaymentRequest']['id']]) ?></td>
					</tr>
				<?php endforeach; ?>
			<?php else: ?>
				<tr>
					<td colspan="5">
						<?php echo __d('buzz_diary_accounts', 'No outstanding payments') ?>
					</td>
				</tr>
			<?php endif; ?>
		</tbody>
	</table>
</div>


<?php foreach ($data as $row): ?>
	<div class="modal fade" id="detailsModal<?=$row['AccountPaymentRequest']['id']?>" tabindex="-1" role="dialog">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<span class="modal__button modal__close" data-dismiss="modal" aria-label="Close">Close<i class="fa fa-times fa-inline"></i></span>
					<h2><?php echo __d('buzz_diary_accounts', 'Details'); ?></h2>
				</div>
				<div class="modal-body">
					<p>
						<strong><?=__d('buzz_diary_accounts', 'Name')?>:</strong> <?=$this->Number->currency($row['AccountPaymentRequest']['amount'])?><br>
						<strong><?=__d('buzz_diary_accounts', 'Email')?>:</strong> <?=$row['AccountPaymentRequest']['email_address']?><br>
						<strong><?=__d('buzz_diary_accounts', 'Reference')?>:</strong> <?=$row['AccountPaymentRequest']['reference']?><br>
					</p>
					<p>
						<strong><?=__d('buzz_diary_accounts', 'Description (included in request email)')?>:</strong><br> <?=$row['AccountPaymentRequest']['description']?>
					</p>
				</div>
			</div>
		</div>
	</div>
<?php endforeach; ?>
