<table class="diary-times">
	<thead>
		<tr>
			<?php // Use the server's timezone rather than CakePHP's to ensure the date is shown correctly. ?>
			<td colspan="3" class="text-center"><?php echo __d('buzz_diary_accounts', 'Times available at %s for %s', [$this->I18n->translate($site, 'Site.name'), $this->Time->i18nFormat(strtotime($date), '%e %B %Y', false, date_default_timezone_get())]); ?></td>
		</tr>
		<tr class="diary-notifications">
			<td colspan="3">
				<?php
					echo $this->Form->create(null, array('url' => array('action' => 'update_notifications', 'plugin' => 'buzz_diary_accounts', $site['Site']['api_site_id'])));
					echo $this->Form->input(
						'notifications',
						array(
							'type' => 'checkbox',
							'label' => __d('buzz_diary_accounts', 'Please email me if more slots on this day become available'),
							'div' => array(
								'class' => 'input checkbox checkbox--custom checkbox--left'
								)
							)
					);
					echo $this->Form->hidden('date');
					echo $this->Form->end();
				?>
			</td>
		</tr>
	</thead>
	<tbody>
	<?php
		$template = null;
		foreach ($data as $time => $slot) {

			$statusClass = 'rotations';
			if (!empty($slot['bookings']) && $slot['my_time'] === $slot['duration']) {
				$statusClass = 'no-rotations';
			} elseif (count($slot['bookings']) === 1 && $slot['available_time'] > 0 && $slot['my_time'] > 0) {
				$statusClass = 'rotations-unconfirmed';
			}

			$class = [];

			$duration = $slot['duration'] / 60;
			$timeSlot = $slot['time'];

			if ($slot['available'] === false && $slot['my_time'] === 0 && $slot['has_camp'] === false) {

				if (!empty($accountUser['Account']['show_unavailable_slots'])) {

					$text = !empty($slot['description']) ? __d('buzz_diary_accounts', '%s (%s booked)', array($slot['description'], $slot['percentage_used'])) : __d('buzz_diary_accounts', 'Not Available');

					echo $this->Html->tag('tr',
						$this->Html->tag('td', $timeSlot, ['class' => 'diary-times__col--time'])
						. $this->Html->tag('td', $text, ['class' => 'diary-times__col--wide-status', 'colspan' => 2]),
						['style' => "min-height:{$duration}px"]
					);

				}

			} else {

				$slotTime = $slot['duration'];
				$campDuration = 0;

				if (!empty($slot['bookings'])) {

					foreach ($slot['bookings'] as $bookingRef => $booking) {

						$duration = $booking['duration'] / 60;
						$class = [];
						$class[] = $statusClass;

						if ($booking['mine'] === true) {

							$slotTime -= $booking['duration'];

							$class[] = 'your-booking';

							if (! empty($camps[$bookingRef])) {
								$text = $this->element('camp', ['camp' => $camps[$bookingRef]]);
							} else {
								$text = __d('buzz_diary_accounts', '%d Minutes Booked', $booking['duration']/60);
							}

							$actions = '&nbsp;';
							if ($slot['booked'] === true && $time > time()) {
								if ($accountUser['Account']['can_create_camps'] === true):
									$actions = $this->Fa->link(
										'plus fa-inline',
										! empty($camps[$bookingRef]) ? __d('buzz_diary_accounts', 'Edit') : __d('buzz_diary_accounts', 'Add Camp'),
										['action' => 'camp', $site['Site']['api_site_id'], $bookingRef, $date],
										[
											'class' => 'js-cancel-booking',
											'data-toggle' => 'modal',
											'data-target' => '#genericModal',
											'before' => true,
											'space' => false
										]
									);
								endif;
								$actions .= ' ' . $this->Fa->link(
									'times fa-inline',
									__d('buzz_diary_accounts', 'Cancel'),
									['action' => 'booking', $site['Site']['api_site_id'], $bookingRef],
									[
										'class' => 'js-cancel-booking',
										'data-toggle' => 'modal',
										'data-target' => '#genericModal',
										'before' => true,
										'space' => false
									]
								);
							}

							echo $this->Html->tag('tr',
								$this->Html->tag('td', $timeSlot?:'&nbsp;', ['class' => 'diary-times__col--time'])
								. $this->Html->tag('td', $text, ['class' => 'diary-times__col--status'])
								. $this->Html->tag('td', $actions, ['class' => 'diary-times__col--actions']),
								['class' => implode(' ', $class), 'style' => "min-height:{$duration}px"]
							);

							$timeSlot = null;

						} elseif (! empty($camps[$bookingRef])) {
							// Camp advert - this booking belongs to another user running a camp.
							$class[] = 'camp-advert';
							$campUrl = ['plugin' => 'buzz_camps', 'controller' => 'camps', 'action' => 'view', $camps[$bookingRef]['Camp']['id']];
							$text = $this->element('camp_advert', ['camp' => $camps[$bookingRef], 'campUrl' => $campUrl]);
							$actions = $this->Fa->link(
								'chevron-circle-right fa-inline',
								__d('buzz_diary_accounts', 'More Info'),
								$campUrl,
								[
									'class' => 'button button--small background--nonary xs-hidden sm-hidden md-hidden',
									'space' => false
								]
							);
							echo $this->Html->tag('tr',
								$this->Html->tag('td', $timeSlot?:'&nbsp;', ['class' => 'diary-times__col--time'])
								. $this->Html->tag('td', $text, ['class' => 'diary-times__col--status'])
								. $this->Html->tag('td', $actions, ['class' => 'diary-times__col--actions']),
								['class' => implode(' ', $class), 'style' => "min-height:{$duration}px"]
							);
							$campDuration += $booking['duration'];

							$timeSlot = null;
						}

					}

				}

				if ($slot['available_time'] > 0 && $slot['available'] === true) {

					$duration = $slot['available_time'] / 60;

					$class = [];
					$class[] = 'available';
					$class[] = $statusClass;

					$mins = $slot['available_time']/60;

					$text = __d('buzz_diary_accounts', 'Available') . ': '
						. __d('buzz_diary_accounts', '%d Minutes', $mins);
					if ($slot['is_last_minute'] === true) {
						$text .= ' ' . __d('buzz_diary_accounts', '(DISCOUNTED)');
					} else {
						$text .= ' ' . ($slot['peak'] === true ? __d('buzz_diary_accounts', '(PEAK)') : __d('buzz_diary_accounts', '(OFF PEAK)'));
					}
					$text = $this->Html->link(
						$text,
						['action' => 'book', $site['Site']['api_site_id'], $slot['timestamp']],
						[
							'class' => 'js-select-time',
							'data-toggle' => 'modal',
							'data-target' => '#genericModal'
						]
					);

					echo $this->Html->tag('tr',
						$this->Html->tag('td', $timeSlot?:'&nbsp;', ['class' => 'diary-times__col--time'])
						. $this->Html->tag('td', $text, ['class' => 'diary-times__col--wide-status', 'colspan' => 2]),
						['class' => implode(' ', $class), 'style' => "min-height:{$duration}px"]
					);

					$timeSlot = null;

				}

				if (! empty($slot['bookings']) && $slot['duration'] - $slot['available_time'] - $campDuration > $slot['my_time']) {

					$text = __d('buzz_diary_accounts', '%d Minutes Booked by Others', ($slot['duration'] - $slot['available_time'] - $slot['my_time'] - $campDuration) / 60);

					$statusClass = $slot['available'] === true || $slot['my_time'] > 0 ? $statusClass : null;

					$duration = $slot['duration'] - $slot['available_time'] - $slot['my_time'];
					$duration /= 60;

					echo $this->Html->tag('tr',
						$this->Html->tag('td', $timeSlot?:'&nbsp;', ['class' => 'diary-times__col--time'])
						. $this->Html->tag('td', $text, ['class' => 'diary-times__col--wide-status', 'colspan' => 2]),
						['class' => $statusClass, 'style' => "min-height:{$duration}px"]
					);

					$timeSlot = null;

				}

			}

		}
	?>
	</tbody>
</table>
