<?php
	$headers = [
		'date' => __d('buzz_diary_accounts', 'Date'),
		'payment_ref' => __d('buzz_diary_accounts', 'Payment Reference'),
		'amount' => __d('buzz_diary_accounts', 'Amount'),
		'payee' => __d('buzz_diary_accounts', 'Payee'),
		'payee_ref' => __d('buzz_diary_accounts', 'Payee Reference')
	];
?>

<div class="overflow-auto">
	<table class="table--flat">
		<thead>
			<tr>
				<th><?php echo implode('</th><th>', $headers); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php if (empty($data)): ?>

				<tr>
					<?php
						echo $this->Html->tag(
							'td',
							__d('buzz_diary_accounts', 'No credits to display'),
							['colspan' => count($headers)]
						);
					?>
				</tr>

			<?php else: ?>

				<?php foreach($data as $row): ?>
					<tr>
						<?php // We need to make sure we treat the dates from the API as in UTC so that they don't get adjusted as they are already in the correct timezone ?>
						<td><?php echo $this->Time->i18nFormat(DiaryApi::dateToTime($row['date']), '%d/%m/%Y', null, 'UTC'); ?></td>
						<td><?php echo h($row['reference']); ?></td>
						<td><?php echo $this->Number->currency($row['amount']); ?></td>
						<td><?php echo !empty($row['extras']['name']) ? h($row['extras']['name']) : h($row['contact_name']); ?></td>
						<td><?php echo !empty($row['extras']['reference']) ? h($row['extras']['reference']) : ' '; ?></td>
					</tr>
				<?php endforeach; ?>

				<?php if (!empty($paged)): ?>
					<tr>
						<?php
							$page = empty($page) ? 1 : $page + 1;
							echo $this->Html->tag(
								'td',
								$this->Html->link(__d('buzz_diary_accounts', 'Load More'), ['controller' => 'account_credits', 'action' => 'get_next_credits', $page, $limit], ['class' => 'js-load-next']),
								['colspan' => count($headers)]
							);
						?>
					</tr>
				<?php endif; // Pager ?>

			<?php endif; ?>
		</tbody>
	</table>
</div>
