<?php
	$headers = [
		'date' => __d('buzz_diary_accounts', 'Date'),
		'time' => __d('buzz_diary_accounts', 'Time'),
		'ref' => __d('buzz_diary_accounts', 'Reference'),
		'date_cancelled' => __d('buzz_diary_accounts', 'Date Cancelled'),
		'cancellation_ref' => __d('buzz_diary_accounts', 'Cancellation Ref')
	];
?>

<div class="overflow-auto">
	<table class="table--flat">
		<thead>
			<tr>
				<th><?php echo implode('</th><th>', $headers); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php if (empty($data)): ?>

				<tr>
					<?php
						echo $this->Html->tag(
							'td',
							__d('buzz_diary_accounts', 'No bookings to display'),
							['colspan' => count($headers)]
						);
					?>
				</tr>

			<?php else: ?>

				<?php foreach($data as $row): ?>
					<tr>
						<?php // We need to make sure we treat the dates from the API as in UTC so that they don't get adjusted as they are already in the correct timezone ?>
						<td><?php echo $this->Time->i18nFormat(DiaryApi::dateToTime($row['date']), '%d/%m/%Y', null, 'UTC'); ?></td>
						<td>
							<?php
								$duration = [];
								if ($row['duration']['hours']):
									$duration[] = __dn('buzz_diary_accounts', '%d hour', '%d hours', $row['duration']['hours'], $row['duration']['hours']);
								endif;
								if ($row['duration']['mins']):
									$duration[] = __dn('buzz_diary_accounts', '%d min', '%d mins', $row['duration']['mins'], $row['duration']['mins']);
								endif;
								echo $row['time'];
								echo ' (' . implode(' ', $duration) . ')';
							?>
						</td>
						<td><?php echo $row['id']; ?></td>
						<td><?php echo !empty($row['cancelled']) ? $this->Time->i18nFormat(DiaryApi::dateToTime($row['cancelled']), '%d/%m/%Y') : '-'; ?></td>
						<td><?php echo $row['cancellation_ref']; ?></td>
					</tr>
				<?php endforeach; ?>

				<?php if (!empty($paged)): ?>
					<tr>
						<?php
							$page = empty($page) ? 1 : $page + 1;
							echo $this->Html->tag(
								'td',
								$this->Html->link(__d('buzz_diary_accounts', 'Load More'), ['action' => 'get_next_cancellations', $page, $limit, !$allowCancellations], ['class' => 'js-load-next']),
								['colspan' => count($headers)]
							);
						?>
					</tr>
				<?php endif; // Pager ?>

			<?php endif; ?>
		</tbody>
	</table>
</div>
