<?php
	$headers = [
		'date' => __d('buzz_diary_accounts', 'Date'),
		'location' => __d('buzz_diary_accounts', 'Location'),
		'ref' => __d('buzz_diary_accounts', 'Reference'),
		'status' => __d('buzz_diary_accounts', 'Rotation Status'),
		'value' => __d('buzz_diary_accounts', 'Value'),
		'' => '',
		'cancel' => __d('buzz_diary_accounts', 'Cancel Booking')
	];
	if (! Configure::read('BuzzSites.show_location')) {
		unset($headers['location']);
	}

	if (empty($accountUser['Account']['show_rates'])):
		unset($headers['value']);
	endif;
	if (empty($allowCancellations)):
		array_pop($headers);
		$allowCancellations = false;
	endif;
?>

<div class="overflow-auto">
	<table class="table--flat">
		<thead>
			<tr>
				<th><?php echo implode('</th><th>', $headers); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php if (empty($data)): ?>

				<tr>
					<?php
						echo $this->Html->tag(
							'td',
							__d('buzz_diary_accounts', 'No bookings to display'),
							['colspan' => count($headers)]
						);
					?>
				</tr>

			<?php else: ?>

				<?php foreach($data as $row): ?>
					<tr>
						<?php // We need to make sure we treat the dates from the API as in UTC so that they don't get adjusted as they are already in the correct timezone ?>
						<td><?php echo $this->Time->i18nFormat(DiaryApi::dateToTime($row['date']), '%d/%m/%Y', null, 'UTC'); ?> -
							<?php
								$duration = [];
								if ($row['duration']['hours']):
									$duration[] = __dn('buzz_diary_accounts', '%d hour', '%d hours', $row['duration']['hours'], $row['duration']['hours']);
								endif;
								if ($row['duration']['mins']):
									$duration[] = __dn('buzz_diary_accounts', '%d min', '%d mins', $row['duration']['mins'], $row['duration']['mins']);
								endif;
								echo $row['time'];
								echo ' (' . implode(' ', $duration) . ')';
							?>
						</td>
						<?php if (Configure::read('BuzzSites.show_location')): ?>
							<td>
								<?=$sites[$row['siteId']]?>
							</td>
						<?php endif; ?>
						<td><?php echo $row['id']; ?></td>
						<td><?php echo $row['status']=='No' ? __d('buzz_diary_accounts', 'No Rotation') : __d('buzz_diary_accounts', 'Requested'); ?></td>
						<?php if (!empty($accountUser['Account']['show_rates'])): ?>
							<td><?php echo $this->Number->currency($row['value']); ?></td>
						<?php endif; ?>
						<td><?= $this->Html->link(__d('buzz_diary_accounts', 'Details'), ['action' => 'booking', $row['siteId'], $row['id']], ['class' => 'js-refresh-modal', 'data-toggle' => 'modal', 'data-target' => '#genericModal']) ?></td>
						<?php if ($allowCancellations === true): ?>
							<td>
								<?php
									echo $this->Html->link(__d('buzz_diary_accounts', 'View Diary'), ['action' => 'diary', $row['siteId'], date('Y-m-j', DiaryApi::dateToTime($row['date']))]);
								?>
							</td>
						<?php endif; ?>
					</tr>
				<?php endforeach; ?>

				<?php if (!empty($paged)): ?>
					<tr>
						<?php
							$page = empty($page) ? 1 : $page + 1;
							echo $this->Html->tag(
								'td',
								$this->Html->link(__d('buzz_diary_accounts', 'Load More'), ['action' => 'get_next_bookings', $page, $limit, !$allowCancellations], ['class' => 'js-load-next']),
								['colspan' => count($headers)]
							);
						?>
					</tr>
				<?php endif; // Pager ?>

			<?php endif; ?>
		</tbody>
	</table>
</div>
