<?php

$controller = $this->request->params['controller'];
$action     = $this->request->params['action'];

$links = [
	[
		'name' => __d('buzz_diary_accounts', 'Overview'),
		'url' => ['controller' => 'accounts', 'action' => 'index'],
		'active' => $controller === 'accounts' && in_array(
				$action,
				['index', 'bookings', 'past_bookings', 'cancellations', 'credits']
			)
	]
];

if (! empty($sites)):
	foreach ($sites as $site):
		$isActive = false;
		if ($action == 'diary' && $this->request->pass[0] == $site['Site']['api_site_id']):
			$isActive = true;
		endif;

		$name = __d('buzz_diary_accounts', 'Diary');

		if (count($sites) > 1) {
			$name = $this->I18n->translate($site, 'Site.name') . ' ' . $name;
		}

		$links[] = [
			'name' => $name,
			'url' => ['controller' => 'accounts', 'action' => 'diary', $site['Site']['api_site_id']],
			'active' => $isActive,
			'params' => [
				'data-id' => $site['Site']['api_site_id']
			]
		];
	endforeach;
endif;

$links[] = [
	'name' => __d('buzz_diary_accounts', 'My Account'),
	'url' => ['controller' => 'accounts', 'action' => 'update'],
	'active' => $controller === 'accounts' && in_array(
			$action,
			['update']
		)
];

$links[] = [
	'name' => __d('buzz_diary_accounts', 'Credits'),
	'url' => ['controller' => 'account_credits', 'action' => 'index'],
	'active' => $controller === 'account_credits' || $controller === 'account_payment_requests'
];

$tabs = '';
foreach ($links as $link):

	$params = ['class' => 'r-tabs-tab' . ($link['active'] ? ' r-tabs-state-active' : null)];

	if (! empty($link['params'])):
		$params = array_merge($params, $link['params']);
	endif;

	$tabs .= $this->Html->tag(
		'li',
		$this->Html->link($link['name'], $link['url']),
		$params
	);

endforeach;

echo $this->Html->tag('ul', $tabs, ['class' => 'r-tabs-nav']);
