<div id="account-info" class="account-info ajax-loader" data-src="<?php echo $this->Html->url(['plugin' => 'buzz_diary_accounts', 'controller' => 'accounts', 'action' => 'get_account']); ?>" data-rates="<?php echo $accountUser['Account']['show_rates'] === true ? $this->Html->url(['plugin' => 'buzz_diary_accounts', 'controller' => 'accounts', 'action' => 'get_account_rates']) : 0; ?>">

	<div class="account-info__header">
		<h3><?php echo __d('buzz_diary_accounts', 'Account Info'); ?></h3>
		<?php
			echo $this->Html->link(
				$accountUser['Account']['full_name'],
				[
					'plugin' => 'buzz_diary_accounts',
					'controller' => 'accounts',
					'action' => 'index'
				]
			);
		?>
		<br />
		<?php
			echo $this->Html->link(
				__d('buzz_diary_accounts', 'Logout'),
				[
					'plugin' => 'buzz_diary_accounts',
					'controller' => 'accounts',
					'action' => 'logout'
				],
				['class' => 'underline']
			);
		?>
	</div>

	<hr />

	<?php
		echo $this->Form->create(
			'Account',
			array(
				'id' => 'AccountToggleFinancialForm',
				'url' => array(
					'plugin' => 'buzz_diary_accounts',
					'controller' => 'accounts',
					'action' => 'toggle_account_rates'
				),
				'class' => 'account-info__toggle-rates'
			)
		);
		echo $this->Form->input(
			'Account.show_unavailable_slots',
			array(
				'id' => 'AccountToggleAvailability',
				'label' => __d('buzz_diary_accounts', 'Show Unavailable Times'),
				'checked' => $accountUser['Account']['show_unavailable_slots'] === true ? 'checked' : null,
				'div' => array(
					'class' => 'checkbox--custom'
				),
				'type' => 'checkbox'
			)
		);
		echo $this->Form->input(
			'Account.show_rates',
			array(
				'id' => 'AccountToggleRates',
				'label' => __d('buzz_diary_accounts', 'Show Rates / Credit History'),
				'checked' => $accountUser['Account']['show_rates'] === true ? 'checked' : null,
				'div' => array(
					'class' => 'checkbox--custom'
				),
				'type' => 'checkbox'
			)
		);
	?>
	<hr />
	<?php
		echo $this->Form->end();
	?>

</div>
