<?php if (CakeSession::check('Auth.Account') !== true): ?>
	<div class="box--login">
		<?php echo $this->Form->create('Account', ['url' => ['plugin' => 'buzz_diary_accounts', 'controller' => 'accounts', 'action' => 'login'], 'id' => false]); ?>

		<h3><?php echo __d('buzz_diary_accounts', 'Log in to your Pro Flyer account'); ?></h3>

		<?= $this->Form->input(
			'email',
			['type' => 'email', 'placeholder' => __d('buzz_diary_accounts', 'Email address'), 'label' => __d('buzz_diary_accounts', 'Email')]
		) ?>
		<?= $this->Form->input(
			'password',
			['type' => 'password', 'placeholder' => __d('buzz_diary_accounts', 'Password'), 'label' => __d('buzz_diary_accounts', 'Password')]
		) ?>

		<div class="row">
			<div class="col-xs-12 col-sm-5">
				<?php echo $this->Form->button(__d('buzz_diary_accounts', 'Login'), ['class' => 'button']); ?>
			</div>

			<div class="col-xs-12 col-sm-7">
				<?php echo $this->Html->link(__d('buzz_diary_accounts', 'Forgot password?'), ['plugin' => 'buzz_diary_accounts', 'controller' => 'accounts', 'action' => 'forgotten_password'], ['class' => 'box--login__forgot']); ?>
			</div>
		</div>

		<?php echo $this->Form->end(); ?>

		<?php echo $this->Fa->link('chevron-circle-right fa-inline', __d('buzz_diary_accounts', 'Register for a Pro Flyer account'), ['plugin' => 'buzz_diary_accounts', 'controller' => 'accounts', 'action' => 'register'], ['space' => false]); ?>
	</div>
<?php else: ?>
	<div id="account-info" class="account-info">

		<div class="account-info__header">
			<h3><?php echo __d('buzz_diary_accounts', 'Account Info'); ?></h3>
			<?php
				echo $this->Html->link(
					CakeSession::read('Auth.Account.full_name'),
					[
						'plugin' => 'buzz_diary_accounts',
						'controller' => 'accounts',
						'action' => 'index'
					]
				);
			?>
			<br />
			<?php
				echo $this->Html->link(
					__d('buzz_diary_accounts', 'Logout'),
					[
						'plugin' => 'buzz_diary_accounts',
						'controller' => 'accounts',
						'action' => 'logout'
					],
					['class' => 'underline']
				);
			?>
		</div>

		<div class="content__spacer"></div>

		<?php echo $this->Fa->link('chevron-circle-right fa-inline', __d('buzz_diary_accounts', 'Manage Account'), ['plugin' => 'buzz_diary_accounts', 'controller' => 'accounts', 'action' => 'index'], ['class' => 'button button--fill', 'space' => false]); ?>
	</div>
<?php endif; ?>
