<?php
$this->extend('BuzzDiaryAccounts./Common/diary');
$this->assign('title', 'Pro Flyer Bulk Booking');
?>

<div class="row">
	<div class="col-xs-12 col-sm-9 diary-accounts__my-account">

		<h3><?php echo __d('buzz_diary_accounts', 'Edit Personal Details'); ?></h3>

		<?php echo $this->Form->create('Account', ['class' => 'form--side-labels validate']); ?>

		<?php
			echo $this->Form->inputs([
				'fieldset' => false,
				'Account.id',
				'Account.first_name' => ['label' => __d('buzz_diary_accounts', 'First Name')],
				'Account.last_name' => ['label' => __d('buzz_diary_accounts', 'Last Name')],
				'Account.email' => ['type' => 'email', 'label' => __d('buzz_diary_accounts', 'Email')],
				'CustomerAddress.id' => ['type' => 'hidden'],
				'CustomerAddress.telephone' => ['label' => __d('buzz_diary_accounts', 'Contact Number')],
				'CustomerAddress.address_line_1' => ['label' => __d('buzz_diary_accounts', 'Address')],
				'CustomerAddress.city' => ['label' => __d('buzz_diary_accounts', 'City')],
				'CustomerAddress.country_id' => ['label' => __d('buzz_diary_accounts', 'Country'), 'div' => 'input select js-country'],
				'CustomerAddress.postcode' => ['label' => __d('buzz_diary_accounts', 'Postcode'), 'div' => 'input text js-postcode', 'class' => 'text-uppercase']
			]);
			echo $this->Form->button(__d('buzz_diary_accounts', 'Update Details') . '<i class="fa fa-chevron-circle-right fa-inline"></i>', ['class' => 'button']);
		?>

		<?php echo $this->Form->end(); ?>

		<div class="content__spacer"></div>

		<h3><?php echo __d('buzz_diary_accounts', 'Edit Password'); ?></h3>

		<?php echo $this->Form->create('Account', ['id' => 'AccountChangePassword', 'action' => 'update_password', 'class' => 'form--side-labels validate']); ?>

		<?php
			echo $this->Form->inputs([
				'fieldset' => false,
				'Account.id',
				'Account.current_password' => ['type' => 'password', 'label' => __d('buzz_diary_accounts', 'Current Password'), 'required' => true, 'div' => 'input password required'],
				'Account.password' => ['type' => 'password', 'label' => __d('buzz_diary_accounts', 'New Password'), 'value' => ''],
				'Account.confirm_password' => ['type' => 'password', 'label' => __d('buzz_diary_accounts', 'Confirm New Password')]
			]);
			echo $this->Form->button(__d('buzz_diary_accounts', 'Update Password') . '<i class="fa fa-chevron-circle-right fa-inline"></i>', ['class' => 'button']);
		?>

		<?php echo $this->Form->end(); ?>

	</div>
</div>
