<?php
$this->extend('/Common/view');
$this->assign('title', __d('buzz_diary_accounts', 'Pro Flyer Account Registration'));
$this->start('meta');
?>
<meta name="robots" content="noindex, nofollow" />
<?php $this->end('meta'); ?>
<div class="outline--septenary outline--thin background--white padding-gutters-1_2">
	<div class="row">
		<div class="col-xs-7 col-xs-push-1">
			<?php echo $this->Form->create('Account', ['class' => 'form--side-labels validate']); ?>

			<p><?php echo __d('buzz_diary_accounts', 'Please complete the form below to create your account'); ?></p>

			<?php
				echo $this->Form->inputs([
					'fieldset' => false,
					'Account.id',
					'Account.first_name' => ['label' => __d('buzz_diary_accounts', 'First Name')],
					'Account.last_name' => ['label' => __d('buzz_diary_accounts', 'Last Name')],
					'Account.email' => ['type' => 'email', 'label' => __d('buzz_diary_accounts', 'Email')],
					'CustomerAddress.telephone' => ['label' => __d('buzz_diary_accounts', 'Contact Number')],
					'CustomerAddress.address_line_1' => ['label' => __d('buzz_diary_accounts', 'Address')],
					'CustomerAddress.city' => ['label' => __d('buzz_diary_accounts', 'City')],
					'CustomerAddress.country_id' => ['label' => __d('buzz_diary_accounts', 'Country')],
					'CustomerAddress.postcode' => ['label' => __d('buzz_diary_accounts', 'Postcode')],
					'Account.password' => ['type' => 'password', 'label' => __d('buzz_diary_accounts', 'Password'), 'value' => ''],
					'Account.confirm_password' => ['type' => 'password', 'label' => __d('buzz_diary_accounts', 'Confirm Password')]
				]);
				if (Configure::read('BuzzDiaryAccounts.show_newsletter_opt_in') === true):
					echo $this->Form->input('Account.newsletter_opt_in', ['label' => __d('buzz_diary_accounts', 'Signup to Exclusive Offers & News'), 'div' => ['class' => 'input checkbox checkbox--custom checkbox--left']]);
				endif;
				echo $this->Form->button(__d('buzz_diary_accounts', 'Register Account') . '<i class="fa fa-chevron-circle-right fa-inline"></i>', ['class' => 'button']);
			?>

			<?php echo $this->Form->end(); ?>
		</div>
	</div>
</div>

<div class="content__spacer"></div>

<?php echo $this->Fa->link('chevron-circle-left fa-inline', __d('buzz_diary_accounts', 'Go Back'), $diaryAccountsLoginUrl, ['before' => true, 'space' => false, 'class' => 'button button--light background--septenary left']); ?>
