<?php
$this->extend('/Common/view');
$this->assign('title', __d('buzz_diary_accounts', 'Password Reset Email Sent'));
$this->start('meta');
?>
<meta name="robots" content="noindex, nofollow" />
<?php $this->end('meta'); ?>
<div class="outline--septenary outline--thin background--white padding-gutters-1_2">
	<div class="row">
		<div class="col-xs-7 col-xs-push-1">
			<?php echo $this->Form->create('Account', ['class' => 'form--side-labels']); ?>

			<p>
				<?php
					echo __d(
						'buzz_diary_accounts',
						'An email has been sent to %s with instructions on how to reset your password.',
						[$this->request->data['Account']['email']]
					);
				?>
			</p>

			<?php
				echo $this->Form->inputs([
					'fieldset' => false,
					'Account.email' => ['type' => 'hidden']
				]);
				echo $this->Form->button(__d('buzz_diary_accounts', 'Resend Email') . '<i class="fa fa-chevron-circle-right fa-inline"></i>', ['class' => 'button']);
			?>

			<?php echo $this->Form->end(); ?>
		</div>
	</div>
</div>

<div class="content__spacer"></div>

<?php echo $this->Fa->link('chevron-circle-left fa-inline', __d('buzz_diary_accounts', 'Go Back'), $diaryAccountsMainPage, ['before' => true, 'space' => false, 'class' => 'button button--light background--septenary left']); ?>
