<?php
$this->extend('/Common/view');
$this->assign('title', __d('buzz_diary_accounts', 'Login'));
$this->start('meta');
?>
<meta name="robots" content="noindex, nofollow" />
<?php $this->end('meta'); ?>
<div class="outline--septenary outline--thin background--white padding-gutters-1_2">
	<div class="row">
		<div class="col-xs-12 col-sm-7 col-sm-push-1">
			<?php echo $this->Form->create('Account', ['class' => 'form--side-labels validate']); ?>

			<?php
				echo $this->Form->inputs(array(
					'fieldset' => false,
					'Account.email' => array('type' => 'email', 'label' => __d('buzz_diary_accounts', 'Email')),
					'Account.password' => array(
						'label' => __d('buzz_diary_accounts', 'Password')
					)
				));
				echo $this->Html->link(
					__d('buzz_diary_accounts', 'Forgot password?'),
					['plugin' => 'buzz_diary_accounts', 'controller' => 'accounts', 'action' => 'forgotten_password'],
					['class' => 'form__indent']
				);
				echo $this->Form->button(__d('buzz_diary_accounts', 'Login') . '<i class="fa fa-chevron-circle-right fa-inline"></i>', ['class' => 'button']);
			?>

			<?php echo $this->Form->end(); ?>

			<div class="content__spacer"></div>

			<?php echo $this->Fa->link('chevron-circle-right fa-inline', __d('buzz_diary_accounts', 'Register for a Pro Flyer account'), ['plugin' => 'buzz_diary_accounts', 'controller' => 'accounts', 'action' => 'register'], ['space' => false, 'class' => 'form__indent']); ?>

		</div>
	</div>
</div>

<div class="content__spacer"></div>

<?php echo $this->Fa->link('chevron-circle-left fa-inline', __d('buzz_diary_accounts', 'Go Back'), $diaryAccountsMainPage, ['before' => true, 'space' => false, 'class' => 'button button--light background--septenary left']); ?>
