<?php
$this->extend('BuzzDiaryAccounts./Common/diary');
echo $this->Html->css(['BuzzDiaryAccounts.buzz_diary_accounts.min'], ['inline' => false]);
?>

<div class="row overview">
	<div class="col-xs-12 col-sm-8">
		<h3><?php echo __d('buzz_diary_accounts', 'Future Bookings') ?></h3>
	</div>
	<div class="col-xs-12 col-sm-4 xs-text-left text-right">
		<?php echo $this->Fa->link('chevron-circle-right fa-inline', __d('buzz_diary_accounts', 'View All Current Bookings'), ['action' => 'bookings'], ['class' => 'overview__link', 'space' => false]); ?>
	</div>
	<div class="col-xs-12 overview__details ajax-loader" data-src="<?php echo $this->Html->url(['action' => 'get_bookings']); ?>">
	</div>
</div>

<div class="row overview">
	<div class="col-xs-12 col-sm-8">
		<h3><?php echo __d('buzz_diary_accounts', 'Past Bookings') ?></h3>
	</div>
	<div class="col-xs-12 col-sm-4 xs-text-left text-right">
		<?php echo $this->Fa->link('chevron-circle-right fa-inline', __d('buzz_diary_accounts', 'View All Past Bookings'), ['action' => 'past_bookings'], ['class' => 'overview__link', 'space' => false]); ?>
	</div>
	<div class="col-xs-12 overview__details ajax-loader" data-src="<?php echo $this->Html->url(['action' => 'get_bookings', 1]); ?>">
	</div>
</div>

<?php if ($accountUser['Account']['show_rates'] === true): ?>
	<div class="row overview">
		<div class="col-xs-12 col-sm-8">
			<h3><?php echo __d('buzz_diary_accounts', 'Credits Added') ?></h3>
		</div>
		<div class="col-xs-12 col-sm-4 xs-text-left text-right">
			<?php echo $this->Fa->link('chevron-circle-right fa-inline', __d('buzz_diary_accounts', 'View All Credits'), ['controller' => 'account_credits', 'action' => 'history'], ['class' => 'overview__link', 'space' => false]); ?>
		</div>
		<div class="col-xs-12 overview__details ajax-loader" data-src="<?php echo $this->Html->url(['controller' => 'account_credits', 'action' => 'get_credits']); ?>">
		</div>
	</div>
<?php endif; ?>

<div class="row overview">
	<div class="col-xs-12 col-sm-8">
		<h3><?php echo __d('buzz_diary_accounts', 'Cancellations') ?></h3>
	</div>
	<div class="col-xs-12 col-sm-4 xs-text-left text-right">
		<?php echo $this->Fa->link('chevron-circle-right fa-inline', __d('buzz_diary_accounts', 'View All Cancellations'), ['action' => 'cancellations'], ['class' => 'overview__link', 'space' => false]); ?>
	</div>
	<div class="col-xs-12 overview__details ajax-loader" data-src="<?php echo $this->Html->url(['action' => 'get_cancellations']); ?>">
	</div>
</div>
