<?php
$this->extend('BuzzDiaryAccounts./Common/diary');
echo $this->Html->css(['BuzzDiaryAccounts.buzz_diary_accounts.min'], ['inline' => false]);
$this->assign('title', 'Pro Flyer Bulk Booking');
?>

<script type="text/javascript">
	// Set any unavailable dates to be disabled in the datepicker
	var unavailableDates = [];
	var bookedDates = [];
<?php
	foreach ($data as $dateKey => $values):
		if ($values['available']===false):
			echo 'unavailableDates.push("' . date('Y-m-d', DiaryApi::dateToTime($dateKey)) . '");';
		endif;
		if ($values['is_booked']===true):
			echo 'bookedDates.push("' . date('Y-m-d', DiaryApi::dateToTime($dateKey)) . '");';
		endif;
	endforeach;
?>
</script>

<div class="row overview site-diary" data-site-id="<?=$siteId?>">
	<div class="col-xs-12 col-sm-4">
		<div class="js-diary-datepicker" data-date="<?php echo $date; ?>" data-min-date="<?php echo $fromDate; ?>" data-max-date="<?php echo $toDate; ?>"></div>

		<div class="diary-accounts__key">
			<h3>Key:</h3>
			<ul>
				<li class="swatch--rotations"><?php echo __d('buzz_diary_accounts', 'Slot rotating with others'); ?></li>
				<li class="swatch--no-rotations"><?php echo __d('buzz_diary_accounts', 'Slot NOT rotating with others'); ?></li>
				<li class="swatch--rotations-unconfirmed"><?php echo __d('buzz_diary_accounts', 'Unconfirmed rotation'); ?></li>
				<li class="swatch--your-booking"><?php echo __d('buzz_diary_accounts', 'Your Bookings'); ?></li>
			</ul>
			<p><?php echo __d('buzz_diary_accounts', 'Note: Times shown as \'Not Available\' may be possible to book by special arrangement.'); ?></p>
		</div>
	</div>
	<div class="col-xs-12 col-sm-8">
		<div class="js-diary-day-view ajax-loader"></div>
	</div>
</div>
