<?php // This is loaded inside .modal-content of #genericModal in default.ctp ?>

<div class="modal-header">
	<span class="modal__button modal__close" data-dismiss="modal" aria-label="Close"><?php echo __d('buzz_diary_accounts', 'Close'); ?><i class="fa fa-times fa-inline"></i></span>
	<h2><?php echo __d('buzz_diary_accounts', 'Details'); ?></h2>
</div>

<div class="modal-body">
	<p>
		<strong><?=__d('buzz_diary_accounts', 'Date')?>:</strong>
		<?= $this->Time->i18nFormat(DiaryApi::dateToTime($data['date']), '%d/%m/%Y', null, 'UTC'); ?><br />
		<strong><?=__d('buzz_diary_accounts', 'Time')?>:</strong>
		<?php
			$duration = [];
			if ($data['duration']['hours']):
				$duration[] = __dn('buzz_diary_accounts', '%d hour', '%d hours', $data['duration']['hours'], $data['duration']['hours']);
			endif;
			if ($data['duration']['mins']):
				$duration[] = __dn('buzz_diary_accounts', '%d min', '%d mins', $data['duration']['mins'], $data['duration']['mins']);
			endif;
			echo h($data['time']);
			echo ' (' . implode(' ', $duration) . ')';
		?>
		<br />

		<strong><?=__d('buzz_diary_accounts', 'Location')?>:</strong> <?=$this->I18n->translate($site, 'Site.name')?>
		<br />
		<strong><?=__d('buzz_diary_accounts', 'Reference')?>:</strong> <?= h($data['id']); ?><br />
		<strong><?=__d('buzz_diary_accounts', 'Rotation Status')?>:</strong>
		<?= $data['status'] == 'No' ? __d('buzz_diary_accounts', 'No Rotation') : __d('buzz_diary_accounts', 'Requested'); ?>
		<br />
		<?php if (!empty($accountUser['Account']['show_rates'])): ?>
			<strong><?=__d('buzz_diary_accounts', 'Value')?>:</strong>
			<?php echo $this->Number->currency($data['value']); ?><br />
			<?php if (! empty($data['value']) && Configure::check('BuzzPurchase.taxPercent')): ?>
				<strong><?= (Configure::check('BuzzPurchase.taxLabel') ? Configure::read('BuzzPurchase.taxLabel') : __('Tax')) ?></strong>
				<?php
					if (Configure::read('BuzzPurchase.showAmount') && Configure::check('BuzzPurchase.showPercent')) {
						echo "(" . Configure::read('BuzzPurchase.taxPercent') . "%) " . $this->Purchase->tax($data['value']);
					} elseif (Configure::read('BuzzPurchase.showAmount')) {
						echo $this->Purchase->tax($data['value']);
					} elseif (Configure::check('BuzzPurchase.showPercent')) {
						echo Configure::read('BuzzPurchase.taxPercent') . "%";
					}
				?>
			<?php endif; ?>
		<?php endif; ?>
	</p>
	<p>
		<strong><?=__d('buzz_diary_accounts', 'Notes')?>:</strong><br />
		<?= h($data['notes']) ?>
	</p>
	<?php if (DiaryApi::dateToTime($data['date']) > time()): ?>
		<?php echo $this->Form->create(); ?>

			<?php echo $this->Form->hidden('ref'); ?>
			<?php echo $this->Form->button(__d('buzz_diary_accounts', 'Cancel this booking'), ['class' => 'button']); ?>

		<?php echo $this->Form->end(); ?>
	<?php endif ?>
</div>
