<?php // This is loaded inside .modal-content of #genericModal in default.ctp ?>

<div class="modal-header">
	<span class="modal__button modal__close" data-dismiss="modal" aria-label="Close"><?php echo __d('buzz_diary_accounts', 'Close'); ?><i class="fa fa-times fa-inline"></i></span>
	<h2><?php echo __d('buzz_diary_accounts', 'Select bulk booking time'); ?></h2>
</div>

<div class="modal-body">
	<?php if (!empty($durations)): ?>

		<?php echo $this->Form->create('Account'); ?>

			<?php
				echo $this->Form->hidden('time');
				echo $this->Form->hidden('hourly_rate');
				echo $this->Form->hidden('rotation', array('value' => $data['rotation']));
				echo $this->Form->hidden('available_time', array('value' => $data['available_time']));
				echo $this->Form->hidden('peak', array('value' => (int)$data['peak']));

				echo $this->Form->input('duration', ['label' => __d('buzz_diary_accounts', 'Duration')]);
			?>


			<?php if ($data['rotation'] === true): ?>

				<?php if ($data['time'] > $data['template']): ?>
					<p class="rotations"><?php echo __d('buzz_diary_accounts', 'Rotating With Others'); ?></p>
				<?php else: ?>
					<p class="rotations js-rotations-text" data-total="<?php echo $data['duration'] / 60; ?>" data-src="<?php echo __d('buzz_diary_accounts', 'Rotations Available'); ?>">
						<?php echo __d('buzz_diary_accounts', 'Rotations NOT Available'); ?>
					</p>
				<?php endif; ?>

			<?php else: ?>

				<p class="no-rotations"><?php echo __d('buzz_diary_accounts', 'Rotating With Others'); ?></p>

			<?php endif; ?>
			<?php if (Configure::read('BuzzSites.show_location')): ?>
				<p><?php echo __d('buzz_diary_accounts', 'Location: %s', [$this->I18n->translate($site, 'Site.name')]); ?></p>
			<?php endif; ?>
			<p><?php echo __d('buzz_diary_accounts', 'Booking Time: %s', [$data['time']]); ?></p>

			<?php if ($accountUser['Account']['show_rates'] === true): ?>
				<p class="js-diary-booking-total-cost" data-rate="<?php echo $rate; ?>">
					<?php echo __d('buzz_diary_accounts', 'Total Cost: %s', ['<span>' . $this->Number->currency($this->request->data['Account']['duration'] * $rate) . '</span>']); ?>
				</p>
			<?php endif; ?>

			<?php echo $this->Form->input('notes', ['type' => 'textarea', 'label' => __d('buzz_diary_accounts', 'Notes')]); ?>

			<?php echo $this->Form->button(__d('buzz_diary_accounts', 'Confirm Booking') . '<i class="fa fa-chevron-circle-right fa-inline"></i>', ['class' => 'button']); ?>

		<?php echo $this->Form->end(); ?>

	<?php else: ?>

		<p><?php echo __d('buzz_diary_accounts', 'You have insufficient credit to make a booking!'); ?></p>
		<p><?php echo $this->Fa->link('plus-circle', __d('buzz_diary_accounts', 'Add Credit'), ['action' => 'add', 'controller' => 'account_credits'], ['class' => 'button', 'before' => true]); ?></p>

	<?php endif; ?>
</div>
