<?php
$this->extend('/Common/view');
$this->assign('title', __d('buzz_diary_accounts', 'Payment Request'));
?>

<?php echo $this->element('BuzzDiaryAccounts.payment_requests_basket', ['data' => $data]); ?>


<?php echo $this->Form->create(); ?>

<div class="row">
	<div class="col-xs-12 col-md-6">

		<h3><?php echo __d('buzz_diary_accounts', 'Billing Details'); ?></h3>

		<div class="form--side-labels form--compact validate">
			<?php echo $this->Element('BuzzCustomers.address_form'); ?>
			<?php echo $this->Form->input('CustomerAddress.email', ['label' => __d('buzz_diary_accounts', 'Email')]); ?>
			<?php echo $this->Form->input('CustomerAddress.telephone', ['label' => __d('buzz_diary_accounts', 'Telephone')]); ?>
		</div>

	</div>
	<div class="col-xs-12 col-md-6">

		<?php if (Configure::read('BuzzPurchase.onsite') === true): ?>
			<h3><?php echo __d('buzz_diary_accounts', 'Payment Details'); ?></h3>
			<div class="form--side-labels form--compact validate">
				<?php echo $this->element('BuzzPurchase.Forms/payment_form'); ?>
			</div>
		<?php endif; ?>

	</div>
</div>

<div class="booking__actions">
	<div class="row">
		<div class="col-xs-6">
			<?php echo $this->Html->link(__d('buzz_diary_accounts', 'Back'), '/', ['class' => 'button button--light background--septenary left']); ?>
		</div>

		<div class="col-xs-6">
			<?php echo $this->Form->button(__d('buzz_diary_accounts', 'Pay Now') . '<i class="fa fa-credit-card fa-inline"></i>', ['class' => 'button button--dark background--senary right']); ?>
		</div>
	</div>
</div>

<?php echo $this->Form->end(); ?>
